/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.smock.common;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.soap.SoapMessage;
import org.springframework.ws.soap.SoapVersion;
import org.springframework.xml.transform.StringResult;
import org.springframework.xml.transform.TransformerHelper;
import org.springframework.xml.xpath.Jaxp13XPathTemplate;
import org.w3c.dom.Document;

public class XmlUtil {
    private static final Map<String, String> SOAP_NAMESPACES = new HashMap<String, String>();

    private XmlUtil() {
    }

    public static Document loadDocument(Source source) {
        DOMResult result = new DOMResult();
        XmlUtil.transform(source, result);
        return (Document)result.getNode();
    }

    public static boolean isSoap(Source source) {
        for (String prefix : SOAP_NAMESPACES.keySet()) {
            String expression = "/" + prefix + ":Envelope";
            Jaxp13XPathTemplate xpathTemplate = new Jaxp13XPathTemplate();
            xpathTemplate.setNamespaces(SOAP_NAMESPACES);
            if (!xpathTemplate.evaluateAsBoolean(expression, source)) continue;
            return true;
        }
        return false;
    }

    public static String serialize(Document document) {
        return XmlUtil.serialize(new DOMSource(document));
    }

    public static Source getEnvelopeSource(WebServiceMessage message) {
        return ((SoapMessage)message).getEnvelope().getSource();
    }

    public static String serialize(Source source) {
        StringResult result = new StringResult();
        XmlUtil.transform(source, (Result)result);
        return result.toString();
    }

    public static void transform(Source source, Result result) {
        try {
            new TransformerHelper().transform(source, result);
        }
        catch (TransformerException e) {
            throw new IllegalArgumentException("Can not transform", e);
        }
    }

    public static InputStream getDocumentAsStream(Document document) {
        return new ByteArrayInputStream(XmlUtil.stringToBytes(XmlUtil.serialize(document)));
    }

    public static InputStream getSourceAsStream(Source source) {
        return new ByteArrayInputStream(XmlUtil.stringToBytes(XmlUtil.serialize(source)));
    }

    public static byte[] stringToBytes(String string) {
        try {
            return string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("UTF8 not supported", e);
        }
    }

    static {
        SOAP_NAMESPACES.put("soap11", SoapVersion.SOAP_11.getEnvelopeNamespaceUri());
        SOAP_NAMESPACES.put("soap12", SoapVersion.SOAP_12.getEnvelopeNamespaceUri());
    }
}

