/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.smock.common.server;

import java.util.Collections;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import net.javacrumbs.smock.common.SmockCommon;
import net.javacrumbs.smock.common.TemplateAwareMessageCreator;
import net.javacrumbs.smock.common.TemplateAwareMessageMatcher;
import net.javacrumbs.smock.common.server.ParametrizableRequestCreator;
import net.javacrumbs.smock.common.server.ParametrizableResponseMatcher;
import org.springframework.core.io.Resource;
import org.w3c.dom.Document;

public class CommonSmockServer
extends SmockCommon {
    private static final Map<String, Object> EMPTY_MAP = Collections.emptyMap();

    public static ParametrizableRequestCreator withMessage(String messageResource) {
        return CommonSmockServer.withMessage(CommonSmockServer.fromResource(messageResource));
    }

    public static ParametrizableRequestCreator withMessage(Resource messageResource) {
        return CommonSmockServer.withMessage(CommonSmockServer.createSource(messageResource));
    }

    public static ParametrizableRequestCreator withMessage(Source message) {
        return new TemplateAwareMessageCreator(message, EMPTY_MAP, CommonSmockServer.getTemplateProcessor());
    }

    public static ParametrizableRequestCreator withMessage(Document message) {
        return CommonSmockServer.withMessage(new DOMSource(message));
    }

    public static ParametrizableResponseMatcher message(String messageResource) {
        return CommonSmockServer.message(CommonSmockServer.fromResource(messageResource));
    }

    public static ParametrizableResponseMatcher message(Resource messageResource) {
        return CommonSmockServer.message(CommonSmockServer.createSource(messageResource));
    }

    public static ParametrizableResponseMatcher message(Source content) {
        return new TemplateAwareMessageMatcher(content, EMPTY_MAP, CommonSmockServer.getTemplateProcessor());
    }

    public static ParametrizableResponseMatcher message(Document message) {
        return CommonSmockServer.message(new DOMSource(message));
    }
}

