/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.springws.test;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.javacrumbs.springws.test.MockWebServiceConnection;
import net.javacrumbs.springws.test.RequestProcessor;
import org.springframework.ws.server.EndpointInterceptor;
import org.springframework.ws.transport.WebServiceConnection;
import org.springframework.ws.transport.WebServiceMessageSender;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMockWebServiceMessageSender
implements WebServiceMessageSender {
    private List<EndpointInterceptor> interceptors = Collections.emptyList();

    public WebServiceConnection createConnection(URI uri) throws IOException {
        MockWebServiceConnection connection = new MockWebServiceConnection(uri);
        connection.setRequestProcessors(this.getRequestProcessors());
        connection.setInterceptors(this.interceptors);
        return connection;
    }

    protected abstract List<RequestProcessor> getRequestProcessors();

    public boolean supports(URI uri) {
        return true;
    }

    public List<EndpointInterceptor> getInterceptors() {
        return Collections.unmodifiableList(this.interceptors);
    }

    public void setInterceptors(List<? extends EndpointInterceptor> interceptors) {
        this.interceptors = new ArrayList<EndpointInterceptor>(interceptors);
    }
}

