/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.springws.test.common;

import org.custommonkey.xmlunit.Diff;
import org.custommonkey.xmlunit.Difference;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

final class EnhancedDiff
extends Diff {
    EnhancedDiff(Document controlDoc, Document testDoc) {
        super(controlDoc, testDoc);
    }

    public int differenceFound(Difference difference) {
        if (difference.isRecoverable()) {
            return 0;
        }
        if ("${IGNORE}".equals(difference.getControlNodeDetail().getValue())) {
            return 2;
        }
        if (this.isDifferenceOnlyInAttributeValuePrefix(difference)) {
            return 2;
        }
        return super.differenceFound(difference);
    }

    boolean isDifferenceOnlyInAttributeValuePrefix(Difference difference) {
        Node testNode = difference.getTestNodeDetail().getNode();
        if (testNode == null) {
            return false;
        }
        String testNodeValue = testNode.getNodeValue();
        Node controlNode = difference.getControlNodeDetail().getNode();
        String controlNodeValue = controlNode.getNodeValue();
        if (this.isAttr(testNode) && this.isAttr(controlNode) && (this.hasNsPrefix(testNodeValue) || this.hasNsPrefix(controlNodeValue))) {
            String testValueNsResolved = this.resolveNamespaces(testNode, testNodeValue);
            String controlValueNsResolved = this.resolveNamespaces(controlNode, controlNodeValue);
            return testValueNsResolved.equals(controlValueNsResolved);
        }
        return false;
    }

    private String resolveNamespaces(Node node, String value) {
        int prefixLength = value.indexOf(58);
        if (prefixLength >= 0) {
            String prefix = value.substring(0, prefixLength);
            String nsUri = node.lookupNamespaceURI(prefix);
            if (nsUri == null) {
                nsUri = prefix;
            }
            return nsUri + value.substring(prefixLength);
        }
        String nsUri = node.lookupNamespaceURI(null);
        return nsUri + ":" + value;
    }

    private boolean hasNsPrefix(String testNodeValue) {
        return testNodeValue.contains(":");
    }

    private boolean isAttr(Node testNode) {
        return testNode instanceof Attr;
    }
}

