/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.springws.test.helper;

import java.io.IOException;
import java.net.URI;
import javax.xml.transform.TransformerException;
import net.javacrumbs.springws.test.helper.InMemoryWebServiceMessageSender;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.client.core.WebServiceMessageCallback;
import org.springframework.ws.client.core.WebServiceMessageExtractor;
import org.springframework.ws.client.core.WebServiceTemplate;
import org.springframework.ws.context.MessageContext;
import org.springframework.ws.transport.WebServiceConnection;

public class WsTestWebServiceTemplate
extends WebServiceTemplate
implements InitializingBean,
ApplicationContextAware {
    private static final WebServiceMessageCallback DUMMY_REQUEST_CALLBACK = new WebServiceMessageCallback(){

        public void doWithMessage(WebServiceMessage message) throws IOException, TransformerException {
        }
    };
    private static final WebServiceMessageExtractor DUMMY_MESSAGE_EXTRACTOR = new WebServiceMessageExtractor(){

        public Object extractData(WebServiceMessage message) throws IOException, TransformerException {
            return null;
        }
    };
    private ApplicationContext applicationContext;

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        if (this.getDefaultUri() == null) {
            this.setDefaultUri("http://test-uri-from-spring-ws-test-should-not-be-vissible");
        }
        InMemoryWebServiceMessageSender messageSender = new InMemoryWebServiceMessageSender();
        messageSender.setApplicationContext(this.applicationContext);
        messageSender.setMessageFactory(this.getMessageFactory());
        messageSender.afterPropertiesSet();
        this.setMessageSender(messageSender);
    }

    protected void send(MessageContext context) throws IOException {
        WebServiceConnection connection = this.getMessageSenders()[0].createConnection(URI.create(this.getDefaultUri()));
        this.doSendAndReceive(context, connection, DUMMY_REQUEST_CALLBACK, DUMMY_MESSAGE_EXTRACTOR);
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }
}

