/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.springws.test.simple;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.javacrumbs.springws.test.MockWebServiceMessageSender;
import net.javacrumbs.springws.test.RequestProcessor;
import net.javacrumbs.springws.test.WsTestException;
import net.javacrumbs.springws.test.context.WsTestContextHolder;
import net.javacrumbs.springws.test.expression.XPathExpressionResolver;
import net.javacrumbs.springws.test.generator.DefaultResponseGenerator;
import net.javacrumbs.springws.test.lookup.ResourceLookup;
import net.javacrumbs.springws.test.lookup.SimpleResourceLookup;
import net.javacrumbs.springws.test.simple.LimitingRequestProcessor;
import net.javacrumbs.springws.test.simple.LimitingRequestProcessorWrapper;
import net.javacrumbs.springws.test.template.FreeMarkerTemplateProcessor;
import net.javacrumbs.springws.test.template.TemplateProcessor;
import net.javacrumbs.springws.test.template.XsltTemplateProcessor;
import net.javacrumbs.springws.test.validator.ExpressionAssertRequestValidator;
import net.javacrumbs.springws.test.validator.SchemaRequestValidator;
import net.javacrumbs.springws.test.validator.XPathRequestValidator;
import net.javacrumbs.springws.test.validator.XmlCompareRequestValidator;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.WebServiceMessageFactory;
import org.springframework.ws.server.EndpointInterceptor;
import org.springframework.ws.transport.WebServiceMessageSender;
import org.springframework.xml.validation.XmlValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WsMockControl {
    private final List<LimitingRequestProcessor> requestProcessors = new ArrayList<LimitingRequestProcessor>();
    private TemplateProcessor templateProcessor = new XsltTemplateProcessor();
    private ResourceLoader resourceLoader = new DefaultResourceLoader();
    private boolean ignoreWhitespace = true;
    private List<EndpointInterceptor> interceptors = new ArrayList<EndpointInterceptor>();

    public WebServiceMessageSender createMock() throws IllegalStateException {
        if (this.requestProcessors.isEmpty()) {
            throw new IllegalStateException("No request processor defined. Please call at least returnResponse() method.");
        }
        MockWebServiceMessageSender messageSender = new MockWebServiceMessageSender();
        messageSender.setRequestProcessors(this.requestProcessors);
        messageSender.setInterceptors(this.interceptors);
        return messageSender;
    }

    public WsMockControl addRequestProcessor(RequestProcessor requestProcessor) {
        return this.addRequestProcessor(requestProcessor, requestProcessor.toString());
    }

    public WsMockControl addRequestProcessor(RequestProcessor requestProcessor, String requestProcessorDescription) {
        if (requestProcessor instanceof LimitingRequestProcessor) {
            this.requestProcessors.add((LimitingRequestProcessor)requestProcessor);
        } else {
            this.requestProcessors.add(new LimitingRequestProcessorWrapper(requestProcessor, requestProcessorDescription));
        }
        return this;
    }

    public WsMockControl expectRequest(String resourceName) {
        return this.expectRequest(this.getResourceLoader().getResource(resourceName));
    }

    public WsMockControl expectRequest(Resource resource) {
        XmlCompareRequestValidator validator = new XmlCompareRequestValidator();
        ResourceLookup resourceLookup = this.createResourceLookup(resource);
        validator.setControlResourceLookup(resourceLookup);
        validator.setFailIfControlResourceNotFound(true);
        validator.setIgnoreWhitespace(this.ignoreWhitespace);
        this.addRequestProcessor(validator, "expectRequest(" + resource.getDescription() + ")");
        return this;
    }

    public WsMockControl validateSchema(Resource ... xsds) {
        SchemaRequestValidator validator = new SchemaRequestValidator();
        validator.setSchemas(xsds);
        try {
            validator.afterPropertiesSet();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Can not create schema validator.", e);
        }
        this.addRequestProcessor(validator);
        return this;
    }

    public WsMockControl validateSchema(String ... xsdPaths) {
        Resource[] resources = new Resource[xsdPaths.length];
        for (int i = 0; i < xsdPaths.length; ++i) {
            resources[i] = this.resourceLoader.getResource(xsdPaths[i]);
        }
        return this.validateSchema(resources);
    }

    public WsMockControl validate(XmlValidator xmlValidator) {
        SchemaRequestValidator validator = new SchemaRequestValidator();
        validator.setValidator(xmlValidator);
        try {
            validator.afterPropertiesSet();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Can not create validator.", e);
        }
        this.addRequestProcessor(validator);
        return this;
    }

    protected ResourceLookup createResourceLookup(Resource resource) {
        SimpleResourceLookup resourceLookup = new SimpleResourceLookup(resource);
        resourceLookup.setTemplateProcessor(this.templateProcessor);
        return resourceLookup;
    }

    public WsMockControl failIf(String expression, Map<String, String> namespaceMap) {
        XPathRequestValidator validator = new XPathRequestValidator();
        validator.setExceptionMapping(Collections.singletonMap(expression, "XPath assertion \"" + expression + "\" failed."));
        XPathExpressionResolver expressionResolver = new XPathExpressionResolver();
        expressionResolver.setNamespaceMap(namespaceMap);
        validator.setExpressionResolver(expressionResolver);
        this.addRequestProcessor(validator, "failIf(\"" + expression + "\")");
        return this;
    }

    public WsMockControl assertThat(String expression, Map<String, String> namespaceMap) {
        ExpressionAssertRequestValidator validator = new ExpressionAssertRequestValidator();
        validator.setAssertExpression(expression);
        XPathExpressionResolver expressionResolver = new XPathExpressionResolver();
        expressionResolver.setNamespaceMap(namespaceMap);
        validator.setExpressionResolver(expressionResolver);
        this.addRequestProcessor(validator, "assertThat(\"" + expression + "\")");
        return this;
    }

    public WsMockControl returnResponse(String resourceName) {
        return this.returnResponse(this.getResourceLoader().getResource(resourceName));
    }

    public WsMockControl returnResponse(Resource resource) {
        DefaultResponseGenerator responseGenerator = new DefaultResponseGenerator();
        ResourceLookup resourceLookup = this.createResourceLookup(resource);
        responseGenerator.setResourceLookup(resourceLookup);
        this.addRequestProcessor(responseGenerator, "returnResponse(" + resource.getDescription() + ")");
        return this;
    }

    public WsMockControl useFreeMarkerTemplateProcessor() {
        FreeMarkerTemplateProcessor freemarkerTemplateProcessor = new FreeMarkerTemplateProcessor();
        freemarkerTemplateProcessor.setResourceLoader(this.resourceLoader);
        freemarkerTemplateProcessor.afterPropertiesSet();
        return this.useTemplateProcessor(freemarkerTemplateProcessor);
    }

    public WsMockControl useXsltTemplateProcessor() {
        return this.useTemplateProcessor(new XsltTemplateProcessor());
    }

    public WsMockControl useTemplateProcessor(TemplateProcessor templateProcessor) {
        this.templateProcessor = templateProcessor;
        return this;
    }

    public WsMockControl throwException(final RuntimeException exception) {
        RequestProcessor thrower = new RequestProcessor(){

            public WebServiceMessage processRequest(URI uri, WebServiceMessageFactory messageFactory, WebServiceMessage request) throws IOException {
                throw exception;
            }
        };
        this.addRequestProcessor(thrower, "throwException(\"" + exception.getMessage() + "\")");
        return this;
    }

    public WsMockControl expectUri(final URI expectedUri) {
        RequestProcessor validator = new RequestProcessor(){

            public WebServiceMessage processRequest(URI uri, WebServiceMessageFactory messageFactory, WebServiceMessage request) throws IOException {
                if (!uri.equals(expectedUri)) {
                    throw new WsTestException("Expected uri " + expectedUri + " but got " + uri);
                }
                return null;
            }
        };
        this.addRequestProcessor(validator, "expectUri(\"" + expectedUri + "\")");
        return this;
    }

    public List<LimitingRequestProcessor> getRequestProcessors() {
        return new ArrayList<LimitingRequestProcessor>(this.requestProcessors);
    }

    public WsMockControl times(int min, int max) {
        if (this.requestProcessors.isEmpty()) {
            throw new IllegalStateException("Can not set behaviour. No request processor defined.");
        }
        LimitingRequestProcessor lastProcessor = this.getLastProcessor();
        lastProcessor.setMinNumberOfProcessedRequests(min);
        lastProcessor.setMaxNumberOfProcessedRequests(max);
        return this;
    }

    public WsMockControl times(int count) {
        return this.times(count, count);
    }

    public WsMockControl once() {
        return this.times(1);
    }

    public WsMockControl anyTimes() {
        return this.times(0, Integer.MAX_VALUE);
    }

    public WsMockControl atLeastOnce() {
        return this.times(1, Integer.MAX_VALUE);
    }

    private LimitingRequestProcessor getLastProcessor() {
        return this.requestProcessors.get(this.requestProcessors.size() - 1);
    }

    public void verify() {
        for (LimitingRequestProcessor processor : this.requestProcessors) {
            processor.verify();
        }
    }

    public ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public boolean isIgnoreWhitespace() {
        return this.ignoreWhitespace;
    }

    public WsMockControl ignoreWhitespace(boolean ignoreWhitespace) {
        this.ignoreWhitespace = ignoreWhitespace;
        return this;
    }

    public WsMockControl addInterceptor(EndpointInterceptor interceptor) {
        this.interceptors.add(interceptor);
        return this;
    }

    public WsMockControl setTestContextAttribute(String name, Object value) {
        WsTestContextHolder.getTestContext().setAttribute(name, value);
        return this;
    }
}

