/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.springws.test.template;

import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Properties;
import net.javacrumbs.springws.test.context.WsTestContextHolder;
import net.javacrumbs.springws.test.template.TemplateProcessor;
import net.javacrumbs.springws.test.util.DefaultXmlUtil;
import net.javacrumbs.springws.test.util.XmlUtil;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.ui.freemarker.FreeMarkerConfigurationFactory;
import org.springframework.ws.WebServiceMessage;

public class FreeMarkerTemplateProcessor
implements TemplateProcessor,
InitializingBean,
ResourceLoaderAware {
    private FreeMarkerConfigurationFactory configurationFactory;
    private ResourceLoader resourceLoader;
    private XmlUtil xmlUtil = DefaultXmlUtil.getInstance();

    public Resource processTemplate(Resource resource, WebServiceMessage message) throws IOException {
        try {
            Configuration configuration = this.configurationFactory.createConfiguration();
            HashMap<String, Object> properties = new HashMap<String, Object>();
            properties.putAll(WsTestContextHolder.getTestContext().getAttributeMap());
            if (message != null) {
                properties.put("request", this.getXmlUtil().loadDocument(message));
            }
            properties.put("IGNORE", "${IGNORE}");
            StringWriter out = new StringWriter();
            configuration.getTemplate(resource.getURL().toString()).process(properties, (Writer)out);
            return new ByteArrayResource(out.toString().getBytes("UTF-8"));
        }
        catch (TemplateException e) {
            throw new IllegalStateException("FreeMarker exception", e);
        }
    }

    public void afterPropertiesSet() {
        if (this.configurationFactory == null) {
            this.configurationFactory = new FreeMarkerConfigurationFactory();
            Properties settings = new Properties();
            settings.put("localized_lookup", "false");
            this.configurationFactory.setFreemarkerSettings(settings);
            this.configurationFactory.setPreTemplateLoaders(new TemplateLoader[]{new SimpleTemplateLoader(this.resourceLoader)});
        }
    }

    public FreeMarkerConfigurationFactory getConfigurationFactory() {
        return this.configurationFactory;
    }

    public void setConfigurationFactory(FreeMarkerConfigurationFactory configurationFactory) {
        this.configurationFactory = configurationFactory;
    }

    public ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public XmlUtil getXmlUtil() {
        return this.xmlUtil;
    }

    public void setXmlUtil(XmlUtil xmlUtil) {
        this.xmlUtil = xmlUtil;
    }

    private static final class SimpleTemplateLoader
    implements TemplateLoader {
        private ResourceLoader resourceLoader;

        public SimpleTemplateLoader(ResourceLoader resourceLoader) {
            this.resourceLoader = resourceLoader;
        }

        public Object findTemplateSource(String name) throws IOException {
            Resource resource = this.resourceLoader.getResource(name);
            return resource.exists() ? resource : null;
        }

        public long getLastModified(Object templateSource) {
            return -1L;
        }

        public Reader getReader(Object templateSource, String encoding) throws IOException {
            Resource resource = (Resource)templateSource;
            return new InputStreamReader(resource.getInputStream(), encoding);
        }

        public void closeTemplateSource(Object templateSource) throws IOException {
        }
    }
}

