/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.springws.test.util;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import net.javacrumbs.springws.test.context.WsTestContextHolder;
import net.javacrumbs.springws.test.util.XmlUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.Resource;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.soap.SoapMessage;
import org.springframework.xml.namespace.SimpleNamespaceContext;
import org.springframework.xml.transform.ResourceSource;
import org.springframework.xml.transform.StringResult;
import org.w3c.dom.Document;

public class DefaultXmlUtil
implements XmlUtil {
    private static final Log logger = LogFactory.getLog(DefaultXmlUtil.class);
    private static final TransformerFactory TRANSFORMER_FACTORY = TransformerFactory.newInstance();
    private static XmlUtil instance = new DefaultXmlUtil();
    private static final String SOAP11_NAMESPACE = "http://schemas.xmlsoap.org/soap/envelope/";
    private static final String SOAP12_NAMESPACE = "http://www.w3.org/2003/05/soap-envelope";
    private static final SimpleNamespaceContext SOAP_NAMESPACE_CONTEXT = new SimpleNamespaceContext();

    public static final XmlUtil getInstance() {
        return instance;
    }

    public static void setInstance(XmlUtil instance) {
        DefaultXmlUtil.instance = instance;
    }

    public Document loadDocument(Source source) {
        DOMResult messageContent = new DOMResult();
        this.transform(source, messageContent);
        return (Document)messageContent.getNode();
    }

    public Document loadDocument(Resource resource) throws IOException {
        return this.loadDocument((Source)new ResourceSource(resource));
    }

    public void transform(Source source, Result result) {
        try {
            TRANSFORMER_FACTORY.newTransformer().transform(source, result);
        }
        catch (TransformerException e) {
            throw new RuntimeException("Unexpected exception", e);
        }
    }

    public void transform(Source template, Source source, Result result) {
        try {
            Transformer transformer = TRANSFORMER_FACTORY.newTransformer(template);
            this.setParameters(transformer);
            transformer.transform(source, result);
        }
        catch (TransformerException e) {
            throw new RuntimeException("Unexpected exception", e);
        }
    }

    private void setParameters(Transformer transformer) {
        for (Map.Entry<String, Object> entry : WsTestContextHolder.getTestContext().getAttributeMap().entrySet()) {
            transformer.setParameter(entry.getKey(), entry.getValue());
        }
    }

    public Document loadDocument(WebServiceMessage message) {
        return this.loadDocument(this.getEnvelopeSource(message));
    }

    public Source getEnvelopeSource(WebServiceMessage message) {
        if (message instanceof SoapMessage) {
            SoapMessage soapMessage = (SoapMessage)message;
            return soapMessage.getEnvelope().getSource();
        }
        throw new UnsupportedOperationException("Can not load message that is not SoapMessage");
    }

    public String serializeDocument(Source source) {
        StringResult result = new StringResult();
        this.transform(source, (Result)result);
        return result.toString();
    }

    public String serializeDocument(WebServiceMessage message) {
        return this.serializeDocument(this.getEnvelopeSource(message));
    }

    public String serializeDocument(Document document) {
        return this.serializeDocument(new DOMSource(document));
    }

    public boolean isSoap(Document document) {
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        xpath.setNamespaceContext((NamespaceContext)SOAP_NAMESPACE_CONTEXT);
        try {
            Iterator iterator = SOAP_NAMESPACE_CONTEXT.getBoundPrefixes();
            while (iterator.hasNext()) {
                String prefix = (String)iterator.next();
                if (!((Boolean)xpath.evaluate("/" + prefix + ":Envelope", document, XPathConstants.BOOLEAN)).booleanValue()) continue;
                return true;
            }
        }
        catch (XPathExpressionException e) {
            logger.warn((Object)e);
        }
        return false;
    }

    static {
        HashMap<String, String> bindings = new HashMap<String, String>();
        bindings.put("soap11", SOAP11_NAMESPACE);
        bindings.put("soap12", SOAP12_NAMESPACE);
        SOAP_NAMESPACE_CONTEXT.setBindings(bindings);
    }
}

