/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.springws.test.validator;

import java.io.IOException;
import java.net.URI;
import net.javacrumbs.springws.test.RequestProcessor;
import net.javacrumbs.springws.test.common.SchemaValidator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.Ordered;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.WebServiceMessageFactory;
import org.springframework.xml.validation.XmlValidator;
import org.springframework.xml.xsd.XsdSchema;
import org.springframework.xml.xsd.XsdSchemaCollection;

public class SchemaRequestValidator
implements InitializingBean,
RequestProcessor,
Ordered {
    private SchemaValidator schemaValidator = new SchemaValidator();
    private XmlValidator validator;
    private String schemaLanguage = "http://www.w3.org/2001/XMLSchema";
    private Resource[] schemas;
    protected final Log logger = LogFactory.getLog(this.getClass());
    static final int DEFAULT_ORDER = 20;
    private int order = 20;

    public WebServiceMessage processRequest(URI uri, WebServiceMessageFactory messageFactory, WebServiceMessage request) throws IOException {
        this.validateRequest(uri, request);
        return null;
    }

    protected void validateRequest(URI uri, WebServiceMessage message) throws IOException {
        this.schemaValidator.validate(message, this.validator);
    }

    public void afterPropertiesSet() throws IOException {
        if (this.validator == null && !ObjectUtils.isEmpty((Object[])this.schemas)) {
            this.validator = this.getSchemaValidator().createValidatorFromSchemas(this.schemas, this.schemaLanguage);
        }
        Assert.notNull((Object)this.validator, (String)"Setting 'schema', 'schemas', 'xsdSchema', or 'xsdSchemaCollection' is required");
    }

    public String getSchemaLanguage() {
        return this.schemaLanguage;
    }

    public void setSchemaLanguage(String schemaLanguage) {
        this.schemaLanguage = schemaLanguage;
    }

    public Resource[] getSchemas() {
        return this.schemas;
    }

    public void setSchema(Resource schema) {
        this.setSchemas(new Resource[]{schema});
    }

    public void setSchemas(Resource[] schemas) {
        Assert.notEmpty((Object[])schemas, (String)"schemas must not be empty or null");
        for (int i = 0; i < schemas.length; ++i) {
            Assert.notNull((Object)schemas[i], (String)"schema must not be null");
            Assert.isTrue((boolean)schemas[i].exists(), (String)("schema \"" + schemas[i] + "\" does not exit"));
        }
        this.schemas = schemas;
    }

    public void setXsdSchema(XsdSchema schema) throws IOException {
        this.validator = schema.createValidator();
    }

    public void setXsdSchemaCollection(XsdSchemaCollection schemaCollection) throws IOException {
        this.validator = schemaCollection.createValidator();
    }

    public XmlValidator getValidator() {
        return this.validator;
    }

    public void setValidator(XmlValidator validator) {
        this.validator = validator;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public SchemaValidator getSchemaValidator() {
        return this.schemaValidator;
    }

    public void setSchemaValidator(SchemaValidator schemaValidator) {
        this.schemaValidator = schemaValidator;
    }
}

