/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.api.configurators;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.List;
import java.util.stream.Collectors;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.ForAll;
import net.jqwik.api.configurators.ArbitraryConfigurationException;
import net.jqwik.api.configurators.ArbitraryConfigurator;
import net.jqwik.api.providers.TypeUsage;
import org.apiguardian.api.API;
import org.junit.platform.commons.support.HierarchyTraversalMode;
import org.junit.platform.commons.support.ReflectionSupport;

@API(status=API.Status.MAINTAINED, since="1.0")
public abstract class ArbitraryConfiguratorBase
implements ArbitraryConfigurator {
    private static final String CONFIG_METHOD_NAME = "configure";

    @Override
    public <T> Arbitrary<T> configure(Arbitrary<T> arbitrary, TypeUsage targetType) {
        if (!this.acceptTargetType(targetType)) {
            return arbitrary;
        }
        List<Annotation> annotations = this.configurationAnnotations(targetType);
        for (Annotation annotation : annotations) {
            List<Method> configurationMethods = this.findConfigurationMethods(arbitrary, annotation);
            for (Method configurationMethod : configurationMethods) {
                arbitrary = this.configureWithMethod(arbitrary, annotation, configurationMethod);
            }
        }
        return arbitrary;
    }

    protected boolean acceptTargetType(TypeUsage targetType) {
        return true;
    }

    private List<Annotation> configurationAnnotations(TypeUsage parameter) {
        return parameter.getAnnotations().stream().filter(annotation -> !annotation.annotationType().equals(ForAll.class)).collect(Collectors.toList());
    }

    private <T> Arbitrary<T> configureWithMethod(Arbitrary<T> arbitrary, Annotation annotation, Method configurationMethod) {
        Object configurationResult = ReflectionSupport.invokeMethod((Method)configurationMethod, (Object)this, (Object[])new Object[]{arbitrary, annotation});
        if (configurationResult == null) {
            return arbitrary;
        }
        if (!(configurationResult instanceof Arbitrary)) {
            throw new ArbitraryConfigurationException(configurationMethod);
        }
        return (Arbitrary)configurationResult;
    }

    private <T> List<Method> findConfigurationMethods(Arbitrary<T> arbitrary, Annotation annotation) {
        Class<?> arbitraryClass = arbitrary.getClass();
        return ReflectionSupport.findMethods(this.getClass(), method -> ArbitraryConfiguratorBase.hasCompatibleConfigurationSignature(method, arbitraryClass, annotation), (HierarchyTraversalMode)HierarchyTraversalMode.BOTTOM_UP);
    }

    private static boolean hasCompatibleConfigurationSignature(Method candidate, Class<? extends Arbitrary<?>> arbitraryClass, Annotation annotation) {
        if (!CONFIG_METHOD_NAME.equals(candidate.getName())) {
            return false;
        }
        if (!Arbitrary.class.isAssignableFrom(candidate.getReturnType())) {
            return false;
        }
        if (candidate.getParameterCount() != 2) {
            return false;
        }
        if (candidate.getParameterTypes()[1] != annotation.annotationType()) {
            return false;
        }
        Class<? extends Arbitrary<?>> upperArbitraryType = candidate.getParameterTypes()[0];
        return upperArbitraryType.isAssignableFrom(arbitraryClass);
    }
}

