/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.api.lifecycle;

import net.jqwik.api.lifecycle.PropertyExecutionResult;
import net.jqwik.api.support.ExceptionSupport;
import org.apiguardian.api.API;

@API(status=API.Status.MAINTAINED, since="1.4.0")
public interface PropertyExecutor {
    public PropertyExecutionResult execute();

    @API(status=API.Status.EXPERIMENTAL, since="1.7.4")
    default public PropertyExecutionResult executeAndFinally(Runnable andFinally) {
        try {
            PropertyExecutionResult result = this.execute();
            try {
                andFinally.run();
                return result;
            }
            catch (Throwable throwable) {
                ExceptionSupport.rethrowIfBlacklisted(throwable);
                return result.mapToFailed(throwable);
            }
        }
        catch (Throwable throwable) {
            ExceptionSupport.rethrowIfBlacklisted(throwable);
            try {
                andFinally.run();
            }
            catch (Throwable cause) {
                throw new RuntimeException(cause);
            }
            throw throwable;
        }
    }

    @FunctionalInterface
    public static interface Runnable {
        public void run() throws Throwable;
    }
}

