/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.api.lifecycle;

import java.util.Optional;
import javax.annotation.Nullable;
import net.jqwik.api.lifecycle.LifecycleContext;
import net.jqwik.api.lifecycle.LifecycleHook;
import org.apiguardian.api.API;

@API(status=API.Status.MAINTAINED, since="1.4.0")
@FunctionalInterface
public interface SkipExecutionHook
extends LifecycleHook {
    @API(status=API.Status.INTERNAL)
    public static final SkipExecutionHook DO_NOT_SKIP = descriptor -> SkipResult.doNotSkip();

    public SkipResult shouldBeSkipped(LifecycleContext var1);

    public static class SkipResult {
        private final boolean skipped;
        private final String reason;

        public static SkipResult skip(@Nullable String reason) {
            return new SkipResult(true, reason);
        }

        public static SkipResult doNotSkip() {
            return new SkipResult(false, null);
        }

        private SkipResult(boolean skipped, String reason) {
            this.skipped = skipped;
            this.reason = reason == null || reason.isEmpty() ? null : reason;
        }

        public boolean isSkipped() {
            return this.skipped;
        }

        public Optional<String> reason() {
            return Optional.ofNullable(this.reason);
        }

        public String toString() {
            String skipString = this.skipped ? "skip" : "do not skip";
            String reasonString = this.reason().map(reason -> ": " + reason).orElse("");
            return String.format("SkipResult(%s%s)", skipString, reasonString);
        }
    }
}

