/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.execution;

import java.lang.reflect.InvocationTargetException;
import net.jqwik.api.JqwikException;
import net.jqwik.api.Reporter;
import net.jqwik.api.domains.DomainContext;
import net.jqwik.api.lifecycle.ContainerLifecycleContext;
import net.jqwik.api.lifecycle.LifecycleContext;
import net.jqwik.api.lifecycle.PropertyExecutionResult;
import net.jqwik.api.lifecycle.PropertyLifecycleContext;
import net.jqwik.api.lifecycle.ProvidePropertyInstanceHook;
import net.jqwik.api.lifecycle.ResolveParameterHook;
import net.jqwik.api.lifecycle.SkipExecutionHook;
import net.jqwik.engine.descriptor.ContainerClassDescriptor;
import net.jqwik.engine.descriptor.PropertyMethodDescriptor;
import net.jqwik.engine.execution.DefaultContainerLifecycleContext;
import net.jqwik.engine.execution.DefaultPropertyLifecycleContext;
import net.jqwik.engine.execution.DomainContextFactory;
import net.jqwik.engine.execution.PropertyExecutionListener;
import net.jqwik.engine.execution.PropertyMethodExecutor;
import net.jqwik.engine.execution.TestInstanceCreator;
import net.jqwik.engine.execution.lifecycle.CurrentDomainContext;
import net.jqwik.engine.execution.lifecycle.CurrentTestDescriptor;
import net.jqwik.engine.execution.lifecycle.ExtendedPropertyExecutionResult;
import net.jqwik.engine.execution.lifecycle.LifecycleHooksSupplier;
import net.jqwik.engine.execution.lifecycle.PlainExecutionResult;
import net.jqwik.engine.execution.lifecycle.StoreRepository;
import net.jqwik.engine.execution.pipeline.ExecutionTask;
import net.jqwik.engine.execution.pipeline.TaskExecutionResult;
import net.jqwik.engine.execution.reporting.DefaultReporter;
import net.jqwik.engine.support.JqwikExceptionSupport;
import org.junit.platform.engine.TestDescriptor;

class PropertyTaskCreator {
    PropertyTaskCreator() {
    }

    ExecutionTask createTask(PropertyMethodDescriptor methodDescriptor, LifecycleHooksSupplier lifecycleSupplier, boolean reportOnlyFailures) {
        return ExecutionTask.from((listener, predecessorResult) -> {
            if (!predecessorResult.successful()) {
                String reason = String.format("Skipped due to container failure: %s", predecessorResult.throwable().orElse(null));
                listener.executionSkipped(methodDescriptor, reason);
                return predecessorResult;
            }
            try {
                PropertyLifecycleContext propertyLifecycleContext = this.createLifecycleContext(methodDescriptor, lifecycleSupplier, (PropertyExecutionListener)listener);
                SkipExecutionHook.SkipResult skipResult = CurrentTestDescriptor.runWithDescriptor(methodDescriptor, () -> {
                    SkipExecutionHook skipExecutionHook = lifecycleSupplier.skipExecutionHook(methodDescriptor);
                    return skipExecutionHook.shouldBeSkipped((LifecycleContext)propertyLifecycleContext);
                });
                if (skipResult.isSkipped()) {
                    listener.executionSkipped(methodDescriptor, skipResult.reason().orElse(null));
                    return TaskExecutionResult.success();
                }
                listener.executionStarted(methodDescriptor);
                try {
                    DomainContext domainContext = this.createDomainContext(methodDescriptor, propertyLifecycleContext);
                    CurrentDomainContext.runWithContext(domainContext, () -> {
                        PropertyExecutionResult executionResult = this.executeTestMethod(methodDescriptor, propertyLifecycleContext, lifecycleSupplier, reportOnlyFailures);
                        listener.executionFinished(methodDescriptor, executionResult);
                        return null;
                    });
                }
                finally {
                    StoreRepository.getCurrent().finishScope(methodDescriptor);
                }
            }
            catch (Throwable throwable) {
                JqwikExceptionSupport.rethrowIfBlacklisted(throwable);
                this.handleExceptionDuringTestInstanceCreation(methodDescriptor, (PropertyExecutionListener)listener, throwable);
            }
            return TaskExecutionResult.success();
        }, methodDescriptor, "executing " + methodDescriptor.getDisplayName());
    }

    private DomainContext createDomainContext(PropertyMethodDescriptor methodDescriptor, PropertyLifecycleContext propertyLifecycleContext) {
        DomainContextFactory domainContextFactory = new DomainContextFactory(propertyLifecycleContext, methodDescriptor);
        return domainContextFactory.createCombinedDomainContext();
    }

    private PropertyLifecycleContext createLifecycleContext(PropertyMethodDescriptor methodDescriptor, LifecycleHooksSupplier lifecycleSupplier, PropertyExecutionListener listener) {
        ResolveParameterHook resolveParameterHook = lifecycleSupplier.resolveParameterHook(methodDescriptor);
        DefaultReporter reporter = new DefaultReporter(listener::reportingEntryPublished, methodDescriptor);
        Object testInstance = this.createTestInstance(methodDescriptor, lifecycleSupplier, reporter);
        DefaultPropertyLifecycleContext propertyLifecycleContext = new DefaultPropertyLifecycleContext(methodDescriptor, testInstance, reporter, resolveParameterHook);
        return propertyLifecycleContext;
    }

    private void handleExceptionDuringTestInstanceCreation(PropertyMethodDescriptor methodDescriptor, PropertyExecutionListener listener, Throwable throwable) {
        listener.executionStarted(methodDescriptor);
        ExtendedPropertyExecutionResult executionResult = PlainExecutionResult.failed(throwable, methodDescriptor.getConfiguration().getSeed());
        listener.executionFinished(methodDescriptor, executionResult);
    }

    private Object createTestInstance(PropertyMethodDescriptor methodDescriptor, LifecycleHooksSupplier lifecycleSupplier, Reporter reporter) {
        try {
            return methodDescriptor.getParent().map(containerDescriptor -> {
                ResolveParameterHook resolveParameterHook = lifecycleSupplier.resolveParameterHook((TestDescriptor)containerDescriptor);
                ProvidePropertyInstanceHook providePropertyInstanceHook = lifecycleSupplier.providePropertyInstanceHook((TestDescriptor)containerDescriptor);
                DefaultContainerLifecycleContext containerLifecycleContext = new DefaultContainerLifecycleContext((ContainerClassDescriptor)containerDescriptor, reporter, resolveParameterHook);
                return CurrentTestDescriptor.runWithDescriptor(containerDescriptor, () -> this.createTestInstanceWithResolvedParameters(containerLifecycleContext, (ContainerClassDescriptor)containerDescriptor, providePropertyInstanceHook));
            }).orElseThrow(() -> new JqwikException("Method descriptors must have a parent"));
        }
        catch (JqwikException jqwikException) {
            throw jqwikException;
        }
        catch (Throwable throwable) {
            JqwikExceptionSupport.rethrowIfBlacklisted(throwable);
            String message = String.format("Cannot create instance of class '%s'", methodDescriptor.getContainerClass());
            if (throwable instanceof InvocationTargetException) {
                throwable = ((InvocationTargetException)throwable).getTargetException();
            }
            throw new JqwikException(message, throwable);
        }
    }

    private Object createTestInstanceWithResolvedParameters(ContainerLifecycleContext containerLifecycleContext, ContainerClassDescriptor containerDescriptor, ProvidePropertyInstanceHook providePropertyInstanceHook) {
        TestInstanceCreator testInstanceCreator = new TestInstanceCreator(containerLifecycleContext, containerDescriptor, providePropertyInstanceHook);
        return testInstanceCreator.create();
    }

    private PropertyExecutionResult executeTestMethod(PropertyMethodDescriptor methodDescriptor, PropertyLifecycleContext propertyLifecycleContext, LifecycleHooksSupplier lifecycleSupplier, boolean reportOnlyFailures) {
        PropertyMethodExecutor executor = new PropertyMethodExecutor(methodDescriptor, propertyLifecycleContext, reportOnlyFailures);
        return executor.execute(lifecycleSupplier);
    }
}

