/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.execution.reporting;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.jqwik.engine.execution.reporting.LineReporter;
import net.jqwik.engine.execution.reporting.ValueReport;

class MapValueReport
extends ValueReport {
    private static final int MAX_LINE_LENGTH = 100;
    private final List<Map.Entry<ValueReport, ValueReport>> reportEntries;

    MapValueReport(Optional<String> label, List<Map.Entry<ValueReport, ValueReport>> reportEntries) {
        super(label);
        this.reportEntries = reportEntries;
    }

    @Override
    public String singleLineReport() {
        return this.label.orElse("") + "{" + this.singleLineEntries() + "}";
    }

    private String singleLineEntries() {
        return this.reportEntries.stream().map(this::singleLineEntry).collect(Collectors.joining(", "));
    }

    private String singleLineEntry(Map.Entry<ValueReport, ValueReport> entry) {
        return String.format("%s=%s", entry.getKey().singleLineReport(), entry.getValue().singleLineReport());
    }

    @Override
    public void report(LineReporter lineReporter, int indentLevel, String appendix) {
        lineReporter.addLine(indentLevel, this.label.orElse("") + "{");
        this.reportEntries(lineReporter, indentLevel + 1);
        lineReporter.addLine(indentLevel, "}" + appendix);
    }

    private void reportEntries(LineReporter lineReporter, int indentLevel) {
        for (int i = 0; i < this.reportEntries.size(); ++i) {
            boolean isNotLast = i < this.reportEntries.size() - 1;
            Map.Entry<ValueReport, ValueReport> reportEntry = this.reportEntries.get(i);
            String optionalComma = isNotLast ? ", " : "";
            String singleLineEntry = this.singleLineEntry(reportEntry);
            if (singleLineEntry.length() + indentLevel * 2 <= 100) {
                lineReporter.addLine(indentLevel, singleLineEntry + optionalComma);
                continue;
            }
            lineReporter.addLine(indentLevel, String.format("%s=", reportEntry.getKey().singleLineReport()));
            reportEntry.getValue().report(lineReporter, indentLevel + 1, optionalComma);
        }
    }
}

