/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries;

import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.jqwik.api.Arbitraries;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.CannotFindArbitraryException;
import net.jqwik.api.Combinators;
import net.jqwik.api.JqwikException;
import net.jqwik.api.arbitraries.ArbitraryDecorator;
import net.jqwik.api.arbitraries.TraverseArbitrary;
import net.jqwik.api.providers.TypeUsage;
import net.jqwik.api.support.HashCodeSupport;
import net.jqwik.api.support.LambdaSupport;
import net.jqwik.engine.support.JqwikReflectionSupport;
import net.jqwik.engine.support.types.TypeUsageImpl;
import org.junit.platform.commons.support.ModifierSupport;

public class DefaultTraverseArbitrary<T>
extends ArbitraryDecorator<T>
implements TraverseArbitrary<T> {
    private final Class<T> targetType;
    private final TraverseArbitrary.Traverser traverser;
    private final Map<TypeUsage, Arbitrary<Object>> arbitrariesCache;
    private boolean enableRecursion = false;

    public DefaultTraverseArbitrary(Class<T> targetType, TraverseArbitrary.Traverser traverser) {
        this(targetType, traverser, new LinkedHashMap<TypeUsage, Arbitrary<Object>>());
    }

    private DefaultTraverseArbitrary(Class<T> targetType, TraverseArbitrary.Traverser traverser, Map<TypeUsage, Arbitrary<Object>> arbitrariesCache) {
        this.targetType = targetType;
        this.traverser = traverser;
        this.arbitrariesCache = arbitrariesCache;
    }

    protected Arbitrary<T> arbitrary() {
        TypeUsage targetTypeUsage = TypeUsage.forType(this.targetType);
        List arbitraries = this.streamCreators(targetTypeUsage).map(this::createArbitrary).collect(Collectors.toList());
        if (arbitraries.isEmpty()) {
            String message = String.format("No usable generator executables (constructors or factory methods) have been provided for type [%s].", this.targetType);
            throw new JqwikException(message);
        }
        return Arbitraries.oneOf(arbitraries);
    }

    private Stream<Executable> streamCreators(TypeUsage targetTypeUsage) {
        Set creators = this.traverser.findCreators(targetTypeUsage);
        return creators.stream().filter(this::constructorIsConcrete).filter(this::methodIsStatic).filter(this::isNotRecursive).map(this::checkFittingReturnType);
    }

    private boolean constructorIsConcrete(Executable executable) {
        if (executable instanceof Constructor) {
            Constructor ctor = (Constructor)executable;
            return !ModifierSupport.isAbstract(this.targetType);
        }
        return true;
    }

    private boolean methodIsStatic(Executable executable) {
        if (executable instanceof Method) {
            Method method = (Method)executable;
            return ModifierSupport.isStatic((Member)method);
        }
        return true;
    }

    public TraverseArbitrary<T> enableRecursion() {
        DefaultTraverseArbitrary clone = (DefaultTraverseArbitrary)this.typedClone();
        clone.enableRecursion = true;
        return clone;
    }

    private Executable checkFittingReturnType(Executable creator) {
        TypeUsage returnType = TypeUsage.forType((Type)creator.getAnnotatedReturnType().getType());
        if (!returnType.canBeAssignedTo(TypeUsage.of(this.targetType, (TypeUsage[])new TypeUsage[0]))) {
            throw new JqwikException(String.format("%s should return type assignable to %s", creator, this.targetType));
        }
        return creator;
    }

    private boolean isNotRecursive(Executable creator) {
        return Arrays.stream(creator.getParameterTypes()).noneMatch(parameterType -> parameterType.equals(this.targetType));
    }

    public String toString() {
        return String.format("TraverseArbitrary<%s>(allowRecursion=%s)", this.targetType.getName(), this.enableRecursion);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        DefaultTraverseArbitrary that = (DefaultTraverseArbitrary)((Object)o);
        if (this.enableRecursion != that.enableRecursion) {
            return false;
        }
        if (!this.targetType.equals(that.targetType)) {
            return false;
        }
        return LambdaSupport.areEqual((Object)this.traverser, (Object)that.traverser);
    }

    public int hashCode() {
        return HashCodeSupport.hash(this.targetType, (Object)this.enableRecursion);
    }

    private Arbitrary<T> createArbitrary(Executable creator) {
        List parameterArbitraries = JqwikReflectionSupport.getMethodParameters(creator, this.targetType).stream().map(methodParameter -> this.arbitraryFor(TypeUsageImpl.forParameter(methodParameter))).collect(Collectors.toList());
        Function<List, Object> combinator = paramList -> this.combinator(creator).apply(paramList.toArray());
        Arbitrary arbitrary = Combinators.combine(parameterArbitraries).as(combinator);
        return arbitrary.ignoreException(GenerationError.class);
    }

    private Arbitrary<Object> arbitraryFor(TypeUsage parameterTypeUsage) {
        Arbitrary arbitrary = this.arbitrariesCache.get(parameterTypeUsage);
        if (arbitrary == null) {
            Optional resolvedArbitrary = this.traverser.resolveParameter(parameterTypeUsage);
            arbitrary = resolvedArbitrary.orElseGet(() -> Arbitraries.defaultFor((TypeUsage)parameterTypeUsage, this::arbitraryForTypeWithoutDefault));
            this.arbitrariesCache.put(parameterTypeUsage, (Arbitrary<Object>)arbitrary);
        }
        return arbitrary;
    }

    private TraverseArbitrary<Object> arbitraryForTypeWithoutDefault(TypeUsage typeUsage) {
        if (!this.enableRecursion) {
            throw new CannotFindArbitraryException(typeUsage);
        }
        DefaultTraverseArbitrary<T> traverseArbitrary = new DefaultTraverseArbitrary<T>(typeUsage.getRawType(), this.traverser, this.arbitrariesCache);
        return traverseArbitrary.enableRecursion();
    }

    private Function<Object[], T> combinator(Executable creator) {
        if (creator instanceof Method) {
            return this.combinatorForMethod((Method)creator);
        }
        if (creator instanceof Constructor) {
            return this.combinatorForConstructor((Constructor)creator);
        }
        throw new JqwikException(String.format("Creator %s is not supported", creator));
    }

    private Function<Object[], T> combinatorForMethod(Method method) {
        method.setAccessible(true);
        return params -> this.generateNext((Object[])params, p -> method.invoke(null, p));
    }

    private Function<Object[], T> combinatorForConstructor(Constructor<T> constructor) {
        constructor.setAccessible(true);
        return params -> this.generateNext((Object[])params, constructor::newInstance);
    }

    private T generateNext(Object[] params, Combinator combinator) {
        try {
            return (T)combinator.combine(params);
        }
        catch (Throwable throwable) {
            throw new GenerationError(throwable);
        }
    }

    private static class GenerationError
    extends RuntimeException {
        GenerationError(Throwable throwable) {
            super(throwable);
        }
    }

    @FunctionalInterface
    private static interface Combinator {
        public Object combine(Object[] var1) throws Throwable;
    }
}

