/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries.combinations;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.EdgeCases;
import net.jqwik.api.ExhaustiveGenerator;
import net.jqwik.api.RandomGenerator;
import net.jqwik.api.Shrinkable;
import net.jqwik.api.support.HashCodeSupport;
import net.jqwik.api.support.LambdaSupport;
import net.jqwik.engine.properties.arbitraries.EdgeCasesSupport;
import net.jqwik.engine.properties.arbitraries.exhaustive.ExhaustiveGenerators;
import net.jqwik.engine.properties.shrinking.CombinedShrinkable;

public class CombineArbitrary<R>
implements Arbitrary<R> {
    private final Function<List<Object>, R> combinator;
    private final List<Arbitrary<Object>> arbitraries;

    public CombineArbitrary(Function<List<Object>, R> combinator, Arbitrary<?> ... arbitraries) {
        this.combinator = combinator;
        this.arbitraries = Arrays.asList(arbitraries);
    }

    public RandomGenerator<R> generator(int genSize) {
        return this.combineGenerator(genSize, this.combinator, this.arbitraries);
    }

    public RandomGenerator<R> generatorWithEmbeddedEdgeCases(int genSize) {
        return this.combineGeneratorWithEmbeddedEdgeCases(genSize, this.combinator, this.arbitraries);
    }

    public Optional<ExhaustiveGenerator<R>> exhaustive(long maxNumberOfSamples) {
        return this.combineExhaustive(this.arbitraries, this.combinator, maxNumberOfSamples);
    }

    public boolean isGeneratorMemoizable() {
        return this.isCombinedGeneratorMemoizable(this.arbitraries);
    }

    public EdgeCases<R> edgeCases(int maxEdgeCases) {
        return this.combineEdgeCases(this.arbitraries, this.combinator, maxEdgeCases);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CombineArbitrary that = (CombineArbitrary)o;
        if (!this.arbitraries.equals(that.arbitraries)) {
            return false;
        }
        return LambdaSupport.areEqual(this.combinator, that.combinator);
    }

    public int hashCode() {
        return HashCodeSupport.hash(this.arbitraries);
    }

    private boolean isCombinedGeneratorMemoizable(List<Arbitrary<Object>> arbitraries) {
        return arbitraries.stream().allMatch(Arbitrary::isGeneratorMemoizable);
    }

    private RandomGenerator<R> combineGenerator(int genSize, Function<List<Object>, R> combineFunction, List<Arbitrary<Object>> arbitraries) {
        List generators = arbitraries.stream().map(a -> a.generator(genSize)).collect(Collectors.toList());
        return random -> {
            List<Shrinkable<Object>> shrinkables = this.generateShrinkables(generators, random);
            return this.combineShrinkables(shrinkables, combineFunction);
        };
    }

    private RandomGenerator<R> combineGeneratorWithEmbeddedEdgeCases(int genSize, Function<List<Object>, R> combineFunction, List<Arbitrary<Object>> arbitraries) {
        List generators = arbitraries.stream().map(a -> a.generatorWithEmbeddedEdgeCases(genSize)).collect(Collectors.toList());
        return random -> {
            List<Shrinkable<Object>> shrinkables = this.generateShrinkables(generators, random);
            return this.combineShrinkables(shrinkables, combineFunction);
        };
    }

    private List<Shrinkable<Object>> generateShrinkables(List<RandomGenerator<Object>> generators, Random random) {
        ArrayList<Shrinkable<Object>> list = new ArrayList<Shrinkable<Object>>();
        for (RandomGenerator<Object> generator : generators) {
            list.add((Shrinkable<Object>)generator.next(random));
        }
        return list;
    }

    private Shrinkable<R> combineShrinkables(List<Shrinkable<Object>> shrinkables, Function<List<Object>, R> combineFunction) {
        return new CombinedShrinkable<R>(shrinkables, combineFunction);
    }

    private Optional<ExhaustiveGenerator<R>> combineExhaustive(List<Arbitrary<Object>> arbitraries, Function<List<Object>, R> combineFunction, long maxNumberOfSamples) {
        return ExhaustiveGenerators.combine(arbitraries, combineFunction, maxNumberOfSamples);
    }

    private EdgeCases<R> combineEdgeCases(List<Arbitrary<Object>> arbitraries, Function<List<Object>, R> combineFunction, int maxEdgeCases) {
        return EdgeCasesSupport.combine(arbitraries, combineFunction, maxEdgeCases);
    }
}

