/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries.combinations;

import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.Combinators;
import net.jqwik.engine.properties.arbitraries.combinations.CombineArbitrary;
import org.apiguardian.api.API;
import org.jetbrains.annotations.NotNull;

public class DefaultListCombinator<T>
implements Combinators.ListCombinator<T> {
    protected final Arbitrary<T>[] arbitraries;

    public DefaultListCombinator(List<Arbitrary<T>> listOfArbitraries) {
        this(listOfArbitraries.toArray(new Arbitrary[0]));
    }

    private DefaultListCombinator(Arbitrary<T>[] arbitraries) {
        this.arbitraries = arbitraries;
    }

    public <R> Arbitrary<R> as(Function<List<T>, @NotNull R> combinator) {
        return new CombineArbitrary<R>(this.combineFunction(combinator), this.arbitraries);
    }

    @API(status=API.Status.EXPERIMENTAL, since="1.7.1")
    public Combinators.ListCombinator<T> filter(Predicate<List<T>> filter) {
        return new Filtered(this.arbitraries, filter);
    }

    protected <R> Function<List<Object>, R> combineFunction(Function<List<T>, R> combinator) {
        return params -> combinator.apply((List)params);
    }

    private static class Filtered<T>
    extends DefaultListCombinator<T> {
        private final Predicate<List<T>> filter;

        private Filtered(Arbitrary<T>[] arbitraries, Predicate<List<T>> filter) {
            super(arbitraries);
            this.filter = filter;
        }

        @Override
        public <R> Arbitrary<R> as(Function<List<T>, @NotNull R> combinator) {
            Predicate<List> filterPredicate = params -> this.filter.test((List<List>)params);
            return new CombineArbitrary(Function.identity(), this.arbitraries).filter(filterPredicate).map(this.combineFunction(combinator));
        }

        @Override
        public Combinators.ListCombinator<T> filter(Predicate<List<T>> filter) {
            return super.filter(this.combineFilters(this.filter, filter));
        }

        private Predicate<List<T>> combineFilters(Predicate<List<T>> first, Predicate<List<T>> second) {
            return first.and(second);
        }
    }
}

