/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries.randomized;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Random;
import net.jqwik.api.RandomDistribution;

public class GaussianNumericGenerator
implements RandomDistribution.RandomNumericGenerator {
    private final double borderSigma;
    private final BigInteger min;
    private final BigInteger max;
    private final BigInteger center;
    private final BigInteger leftRange;
    private final BigInteger rightRange;

    public GaussianNumericGenerator(double borderSigma, BigInteger min, BigInteger max, BigInteger center) {
        this.borderSigma = borderSigma;
        this.min = min;
        this.max = max;
        this.center = center;
        this.leftRange = center.subtract(min).abs();
        this.rightRange = center.subtract(max).abs();
    }

    public BigInteger next(Random random) {
        BigInteger value;
        do {
            double gaussianFactor = random.nextGaussian() / this.borderSigma;
            value = this.center;
            if (gaussianFactor < 0.0 && this.leftRange.compareTo(BigInteger.ZERO) > 0) {
                BigDecimal bigDecimalLeft = new BigDecimal(this.leftRange).multiply(BigDecimal.valueOf(gaussianFactor).abs());
                value = this.center.subtract(bigDecimalLeft.toBigInteger());
            }
            if (!(gaussianFactor > 0.0) || this.rightRange.compareTo(BigInteger.ZERO) <= 0) continue;
            BigDecimal bigDecimalRight = new BigDecimal(this.rightRange).multiply(BigDecimal.valueOf(gaussianFactor).abs());
            value = this.center.add(bigDecimalRight.toBigInteger());
        } while (value.compareTo(this.min) < 0 || value.compareTo(this.max) > 0);
        return value;
    }
}

