/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries.randomized;

import java.util.Random;
import java.util.function.Function;
import net.jqwik.api.RandomGenerator;
import net.jqwik.api.Shrinkable;
import net.jqwik.api.TooManyFilterMissesException;
import net.jqwik.engine.properties.shrinking.IgnoreExceptionShrinkable;
import net.jqwik.engine.support.JqwikExceptionSupport;

public class IgnoreExceptionGenerator<T>
implements RandomGenerator<T> {
    private final RandomGenerator<T> base;
    private final Class<? extends Throwable>[] exceptionTypes;
    private final int maxThrows;

    public IgnoreExceptionGenerator(RandomGenerator<T> base, Class<? extends Throwable>[] exceptionTypes, int maxThrows) {
        this.base = base;
        this.exceptionTypes = exceptionTypes;
        this.maxThrows = maxThrows;
    }

    public Shrinkable<T> next(Random random) {
        return new IgnoreExceptionShrinkable<T>(this.nextUntilAccepted(random, arg_0 -> this.base.next(arg_0)), this.exceptionTypes);
    }

    private Shrinkable<T> nextUntilAccepted(Random random, Function<Random, Shrinkable<T>> fetchShrinkable) {
        for (int i = 0; i < this.maxThrows; ++i) {
            try {
                Shrinkable<T> next = fetchShrinkable.apply(random);
                next.value();
                return next;
            }
            catch (Throwable throwable) {
                if (JqwikExceptionSupport.isInstanceOfAny(throwable, this.exceptionTypes)) continue;
                throw throwable;
            }
        }
        String message = String.format("%s missed more than %s times.", this, this.maxThrows);
        throw new TooManyFilterMissesException(message);
    }
}

