/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries.randomized;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.jqwik.api.RandomGenerator;
import net.jqwik.api.Shrinkable;
import net.jqwik.api.lifecycle.Lifespan;
import net.jqwik.api.lifecycle.Store;
import net.jqwik.engine.SourceOfRandomness;

public class InjectDuplicatesGenerator<T>
implements RandomGenerator<T> {
    private final RandomGenerator<T> base;
    private final double duplicateProbability;
    private final Store<List<Long>> previousSeedsStore;

    public InjectDuplicatesGenerator(RandomGenerator<T> base, double duplicateProbability) {
        this.base = base;
        this.duplicateProbability = duplicateProbability;
        this.previousSeedsStore = this.createPreviousSeedsStorePerTry();
    }

    private Store<List<Long>> createPreviousSeedsStorePerTry() {
        return Store.getOrCreate((Object)this, (Lifespan)Lifespan.TRY, ArrayList::new);
    }

    public Shrinkable<T> next(Random random) {
        long seed = this.chooseSeed(random);
        return this.base.next(SourceOfRandomness.newRandom(seed));
    }

    long chooseSeed(Random random) {
        List previousSeeds = (List)this.previousSeedsStore.get();
        if (!previousSeeds.isEmpty() && random.nextDouble() <= this.duplicateProbability) {
            return this.randomPreviousSeed(this.previousSeedsStore, random);
        }
        long seed = random.nextLong();
        previousSeeds.add(seed);
        return seed;
    }

    private long randomPreviousSeed(Store<List<Long>> previousSeeds, Random random) {
        int index = random.nextInt(((List)previousSeeds.get()).size());
        return (Long)((List)previousSeeds.get()).get(index);
    }
}

