/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.configurators;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.function.Function;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.JqwikException;
import net.jqwik.api.arbitraries.BigIntegerArbitrary;
import net.jqwik.api.configurators.ArbitraryConfiguratorBase;
import net.jqwik.api.constraints.BigRange;
import net.jqwik.api.providers.TypeUsage;
import net.jqwik.engine.properties.arbitraries.DefaultBigIntegerArbitrary;

public class BigIntegerRangeConfigurator
extends ArbitraryConfiguratorBase {
    protected boolean acceptTargetType(TypeUsage targetType) {
        return targetType.isAssignableFrom(BigInteger.class);
    }

    public Arbitrary<BigInteger> configure(Arbitrary<BigInteger> arbitrary, BigRange range) {
        BigInteger min = BigIntegerRangeConfigurator.evaluate(range.min(), val -> new BigDecimal((String)val).toBigIntegerExact(), DefaultBigIntegerArbitrary.DEFAULT_MIN);
        BigInteger max = BigIntegerRangeConfigurator.evaluate(range.max(), val -> new BigDecimal((String)val).toBigIntegerExact(), DefaultBigIntegerArbitrary.DEFAULT_MAX);
        if (!range.minIncluded() || !range.maxIncluded()) {
            String message = "minIncluded and maxIncluded are only allowed for parameters of type java.math.BigDecimal";
            throw new JqwikException(message);
        }
        if (arbitrary instanceof BigIntegerArbitrary) {
            return ((BigIntegerArbitrary)arbitrary).greaterOrEqual(min).lessOrEqual(max);
        }
        return arbitrary.filter(i -> min.compareTo((BigInteger)i) <= 0 && max.compareTo((BigInteger)i) >= 0);
    }

    private static BigInteger evaluate(String valueString, Function<String, BigInteger> evaluator, BigInteger defaultValue) {
        return valueString.isEmpty() ? defaultValue : evaluator.apply(valueString);
    }
}

