/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.configurators;

import net.jqwik.api.Arbitrary;
import net.jqwik.api.arbitraries.LongArbitrary;
import net.jqwik.api.configurators.ArbitraryConfiguratorBase;
import net.jqwik.api.constraints.LongRange;
import net.jqwik.api.providers.TypeUsage;

public class LongRangeConfigurator
extends ArbitraryConfiguratorBase {
    protected boolean acceptTargetType(TypeUsage targetType) {
        return targetType.isAssignableFrom(Long.class);
    }

    public Arbitrary<Long> configure(Arbitrary<Long> arbitrary, LongRange range) {
        if (arbitrary instanceof LongArbitrary) {
            LongArbitrary longArbitrary = (LongArbitrary)arbitrary;
            return longArbitrary.greaterOrEqual(range.min()).lessOrEqual(range.max());
        }
        return arbitrary.filter(i -> i >= range.min() && i <= range.max());
    }
}

