/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.configurators;

import net.jqwik.api.Arbitrary;
import net.jqwik.api.JqwikException;
import net.jqwik.api.arbitraries.StringArbitrary;
import net.jqwik.api.configurators.ArbitraryConfiguratorBase;
import net.jqwik.api.constraints.StringLength;
import net.jqwik.api.providers.TypeUsage;

public class StringLengthConfigurator
extends ArbitraryConfiguratorBase {
    protected boolean acceptTargetType(TypeUsage targetType) {
        return targetType.isOfType(String.class);
    }

    public Arbitrary<String> configure(Arbitrary<String> arbitrary, StringLength stringLength) {
        this.checkSize(stringLength);
        if (arbitrary instanceof StringArbitrary) {
            return this.configureStringArbitrary((StringArbitrary)arbitrary, stringLength);
        }
        return this.configureOtherArbitrary(arbitrary, stringLength);
    }

    private Arbitrary<String> configureOtherArbitrary(Arbitrary<String> arbitrary, StringLength stringLength) {
        if (stringLength.value() != 0) {
            return arbitrary.filter(s -> s.length() == stringLength.value());
        }
        return arbitrary.filter(s -> s.length() >= stringLength.min() && s.length() <= stringLength.max());
    }

    private Arbitrary<String> configureStringArbitrary(StringArbitrary stringArbitrary, StringLength stringLength) {
        if (stringLength.value() != 0) {
            return stringArbitrary.ofLength(stringLength.value());
        }
        StringArbitrary newArbitrary = stringArbitrary;
        if (stringLength.min() != 0) {
            newArbitrary = newArbitrary.ofMinLength(stringLength.min());
        }
        if (stringLength.max() != 0) {
            newArbitrary = newArbitrary.ofMaxLength(stringLength.max());
        }
        return newArbitrary;
    }

    private void checkSize(StringLength stringLength) {
        if (stringLength.value() == 0) {
            if (stringLength.min() > stringLength.max() && stringLength.max() != 0) {
                this.reportError(stringLength);
            }
        } else if (stringLength.min() != 0 || stringLength.max() != 0) {
            this.reportError(stringLength);
        }
    }

    private void reportError(StringLength stringLength) {
        throw new JqwikException(String.format("%s: You have to either choose a fixed value or set min/max", stringLength));
    }
}

