/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.shrinking;

import java.math.BigInteger;
import java.util.Optional;
import java.util.stream.Stream;
import net.jqwik.api.Shrinkable;
import net.jqwik.engine.properties.Range;
import net.jqwik.engine.properties.shrinking.ShrinkableBigInteger;

class BigIntegerGrower {
    BigIntegerGrower() {
    }

    Optional<Shrinkable<BigInteger>> grow(BigInteger value, Range<BigInteger> range, BigInteger shrinkingTarget, Shrinkable<?> before, Shrinkable<?> after) {
        Object afterValue;
        Object beforeValue = before.value();
        BigInteger diff = this.calculateDiff(beforeValue, afterValue = after.value(), value);
        if (diff.compareTo(BigInteger.ZERO) != 0) {
            BigInteger grownValue = value.add(diff);
            if (this.sameSign(shrinkingTarget.subtract(value), shrinkingTarget.subtract(grownValue)) && range.includes(grownValue)) {
                return Optional.of(new ShrinkableBigInteger(grownValue, range, shrinkingTarget));
            }
        }
        return Optional.empty();
    }

    private BigInteger calculateDiff(Object beforeValue, Object afterValue, BigInteger current) {
        BigInteger after;
        BigInteger before;
        if (beforeValue instanceof BigInteger && afterValue instanceof BigInteger) {
            before = (BigInteger)beforeValue;
            after = (BigInteger)afterValue;
        } else {
            before = BigInteger.valueOf(this.toLong(beforeValue));
            after = BigInteger.valueOf(this.toLong(afterValue));
        }
        if (this.sameSign(before, current)) {
            return before.subtract(after);
        }
        return after.subtract(before);
    }

    private boolean sameSign(BigInteger first, BigInteger second) {
        return Math.abs(first.signum() - second.signum()) <= 1;
    }

    private long toLong(Object value) {
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Integer) {
            return ((Integer)value).longValue();
        }
        if (value instanceof Short) {
            return ((Short)value).longValue();
        }
        if (value instanceof Byte) {
            return ((Byte)value).longValue();
        }
        return 0L;
    }

    public Stream<Shrinkable<BigInteger>> grow(BigInteger value, Range<BigInteger> range, BigInteger shrinkingTarget) {
        if (value.compareTo(shrinkingTarget) < 0) {
            return this.growLeft(value, range, shrinkingTarget);
        }
        return this.growRight(value, range, shrinkingTarget);
    }

    private Stream<Shrinkable<BigInteger>> growRight(BigInteger value, Range<BigInteger> range, BigInteger shrinkingTarget) {
        return Stream.of((BigInteger)range.max, value.add(((BigInteger)range.max).subtract(value).divide(BigInteger.valueOf(2L))), value.add(BigInteger.TEN), value.add(BigInteger.ONE)).filter(grownValue -> grownValue.compareTo(value) > 0).filter(range::includes).distinct().map(grown -> new ShrinkableBigInteger((BigInteger)grown, range, shrinkingTarget));
    }

    private Stream<Shrinkable<BigInteger>> growLeft(BigInteger value, Range<BigInteger> range, BigInteger shrinkingTarget) {
        return Stream.of((BigInteger)range.min, value.subtract(value.subtract((BigInteger)range.min).divide(BigInteger.valueOf(2L))), value.subtract(BigInteger.TEN), value.subtract(BigInteger.ONE)).filter(grownValue -> grownValue.compareTo(value) < 0).filter(range::includes).distinct().map(grown -> new ShrinkableBigInteger((BigInteger)grown, range, shrinkingTarget));
    }
}

