/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.providers;

import java.util.List;
import java.util.Set;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.JqwikException;
import net.jqwik.api.providers.ArbitraryProvider;
import net.jqwik.api.providers.TypeUsage;
import net.jqwik.api.support.CollectorsSupport;
import net.jqwik.engine.properties.arbitraries.DefaultArrayArbitrary;

public class ArrayArbitraryProvider
implements ArbitraryProvider {
    public boolean canProvideFor(TypeUsage targetType) {
        return targetType.isArray();
    }

    public Set<Arbitrary<?>> provideFor(TypeUsage targetType, ArbitraryProvider.SubtypeProvider subtypeProvider) {
        TypeUsage componentType = targetType.getComponentType().orElse(TypeUsage.forType(Object.class));
        return (Set)((Set)subtypeProvider.apply((Object)componentType)).stream().map(elementArbitrary -> {
            if (!componentType.isTypeVariable()) {
                Class arrayClass = targetType.getRawType();
                return elementArbitrary.array(arrayClass);
            }
            Class<?> componentClass = this.upperboundsSupertype(componentType);
            return DefaultArrayArbitrary.forComponentType(elementArbitrary, componentClass);
        }).collect(CollectorsSupport.toLinkedHashSet());
    }

    private Class<?> upperboundsSupertype(TypeUsage componentType) {
        List upperBounds = componentType.getUpperBounds();
        if (upperBounds.size() != 1) {
            String message = String.format("jqwik cannot handle more than one upper bound in this case: <%s>", componentType);
            throw new JqwikException(message);
        }
        return ((TypeUsage)upperBounds.get(0)).getRawType();
    }
}

