/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.support;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.jqwik.api.Tuple;
import net.jqwik.engine.support.combinatorics.CombinedIterator;
import net.jqwik.engine.support.combinatorics.ConcatIterator;
import net.jqwik.engine.support.combinatorics.PermutationIterator;
import net.jqwik.engine.support.combinatorics.SetIterator;

public class Combinatorics {
    public static <T> Iterator<List<T>> combine(List<Iterable<T>> listOfIterables) {
        if (listOfIterables.isEmpty()) {
            return Combinatorics.emptyListSingleton();
        }
        return new CombinedIterator<T>(listOfIterables);
    }

    private static <T> Iterator<List<T>> emptyListSingleton() {
        return Arrays.asList(new ArrayList()).iterator();
    }

    private static <T> Iterator<Set<T>> emptySetSingleton() {
        return Arrays.asList(new LinkedHashSet()).iterator();
    }

    public static <T> Iterator<List<T>> listCombinations(Iterable<T> elementIterable, int minSize, int maxSize) {
        ArrayList<Iterator<T>> iterators = new ArrayList<Iterator<T>>();
        for (int listSize = minSize; listSize <= maxSize; ++listSize) {
            iterators.add(Combinatorics.listIterator(elementIterable, listSize));
        }
        return Combinatorics.concatIterators(iterators);
    }

    private static <T> Iterator<List<T>> listIterator(Iterable<T> elementIterable, int listSize) {
        ArrayList<Iterable<T>> listOfIterables = new ArrayList<Iterable<T>>();
        for (int i = 0; i < listSize; ++i) {
            listOfIterables.add(elementIterable);
        }
        return Combinatorics.combine(listOfIterables);
    }

    public static <T> Iterator<Set<T>> setCombinations(Iterable<T> elementIterable, int minSize, int maxSize) {
        ArrayList<Iterator<T>> iterators = new ArrayList<Iterator<T>>();
        for (int setSize = minSize; setSize <= maxSize; ++setSize) {
            Iterator<Set<T>> setIterator = Combinatorics.setIterator(elementIterable, setSize);
            iterators.add(setIterator);
        }
        return Combinatorics.concatIterators(iterators);
    }

    private static <T> Iterator<Set<T>> setIterator(Iterable<T> elementIterable, int setSize) {
        if (setSize == 0) {
            return Combinatorics.emptySetSingleton();
        }
        return new SetIterator<T>(elementIterable, setSize);
    }

    public static <T> Iterator<List<T>> listPermutations(List<T> values) {
        if (values.isEmpty()) {
            return Combinatorics.emptyListSingleton();
        }
        return new PermutationIterator<T>(values);
    }

    public static <T> Iterator<T> concat(List<Iterable<T>> iterables) {
        List iterators = iterables.stream().map(Iterable::iterator).collect(Collectors.toList());
        return new ConcatIterator(iterators);
    }

    private static <T> Iterator<T> concatIterators(List<Iterator<T>> iterators) {
        return new ConcatIterator<T>(iterators);
    }

    public static Stream<Tuple.Tuple2<Integer, Integer>> distinctPairs(int maxExclusive) {
        if (maxExclusive < 2) {
            return Stream.empty();
        }
        ArrayList<Tuple.Tuple2> pairs = new ArrayList<Tuple.Tuple2>();
        for (int i = 0; i < maxExclusive; ++i) {
            for (int j = i + 1; j < maxExclusive; ++j) {
                if (i == j) continue;
                pairs.add(Tuple.of((Object)i, (Object)j));
            }
        }
        return pairs.stream();
    }
}

