/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.support;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public final class OverriddenMethodAnnotationSupport {
    private static final int ACCESS_MODIFIERS = 7;
    private static final List<Integer> ACCESS_ORDER = Arrays.asList(2, 0, 4, 1);

    public static <A extends Annotation> Optional<A> findDeclaredOrInheritedAnnotation(Method m, Class<A> t) {
        List<A> list = OverriddenMethodAnnotationSupport.getAnnotations(m, t);
        return list.isEmpty() ? Optional.empty() : Optional.of((Annotation)list.get(0));
    }

    private static <A extends Annotation> List<A> getAnnotations(Method m, Class<A> t) {
        Class<?> decl;
        ArrayList list = new ArrayList();
        Collections.addAll(list, OverriddenMethodAnnotationSupport.allAnnotationsByType((Method)m, t));
        Class<?> supr = decl = m.getDeclaringClass();
        while ((supr = supr.getSuperclass()) != null) {
            OverriddenMethodAnnotationSupport.addAnnotations(list, m, t, supr);
        }
        for (Class<?> face : OverriddenMethodAnnotationSupport.getAllInterfaces(decl)) {
            OverriddenMethodAnnotationSupport.addAnnotations(list, m, t, face);
        }
        return list;
    }

    private static Set<Class<?>> getAllInterfaces(Class<?> c) {
        LinkedHashSet set = new LinkedHashSet();
        do {
            OverriddenMethodAnnotationSupport.addAllInterfaces(set, c);
        } while ((c = c.getSuperclass()) != null);
        return set;
    }

    private static void addAllInterfaces(Set<Class<?>> set, Class<?> c) {
        for (Class<?> i : c.getInterfaces()) {
            if (!set.add(i)) continue;
            OverriddenMethodAnnotationSupport.addAllInterfaces(set, i);
        }
    }

    private static <A extends Annotation> void addAnnotations(List<A> list, Method m, Class<A> t, Class<?> decl) {
        try {
            Method n = decl.getDeclaredMethod(m.getName(), m.getParameterTypes());
            if (OverriddenMethodAnnotationSupport.overrides(m, n)) {
                Collections.addAll(list, OverriddenMethodAnnotationSupport.allAnnotationsByType((Method)n, t));
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    /*
     * Exception decompiling
     */
    private static <A extends Annotation> A[] allAnnotationsByType(Method m, Class<A> t) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static boolean overrides(Method a, Method b) {
        Class<?>[] paramsB;
        Class<?> classB;
        if (!a.getName().equals(b.getName())) {
            return false;
        }
        Class<?> classA = a.getDeclaringClass();
        if (classA.equals(classB = b.getDeclaringClass())) {
            return false;
        }
        if (!classB.isAssignableFrom(classA)) {
            return false;
        }
        int modsA = a.getModifiers();
        int modsB = b.getModifiers();
        if (Modifier.isPrivate(modsA) || Modifier.isPrivate(modsB)) {
            return false;
        }
        if (Modifier.isStatic(modsA) || Modifier.isStatic(modsB)) {
            return false;
        }
        if (Modifier.isFinal(modsB)) {
            return false;
        }
        if (OverriddenMethodAnnotationSupport.compareAccess(modsA, modsB) < 0) {
            return false;
        }
        if ((OverriddenMethodAnnotationSupport.isPackageAccess(modsA) || OverriddenMethodAnnotationSupport.isPackageAccess(modsB)) && !Objects.equals(classA.getPackage(), classB.getPackage())) {
            return false;
        }
        if (!b.getReturnType().isAssignableFrom(a.getReturnType())) {
            return false;
        }
        Class<?>[] paramsA = a.getParameterTypes();
        if (paramsA.length != (paramsB = b.getParameterTypes()).length) {
            return false;
        }
        for (int i = 0; i < paramsA.length; ++i) {
            if (paramsA[i].equals(paramsB[i])) continue;
            return false;
        }
        return true;
    }

    private static boolean isPackageAccess(int mods) {
        return (mods & 7) == 0;
    }

    private static int compareAccess(int lhs, int rhs) {
        return Integer.compare(ACCESS_ORDER.indexOf(lhs & 7), ACCESS_ORDER.indexOf(rhs & 7));
    }
}

