/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.support.types;

import java.lang.annotation.Annotation;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import net.jqwik.api.providers.TypeUsage;

class TypeUsageToString {
    TypeUsageToString() {
    }

    public static String toString(TypeUsage self) {
        return TypeUsageToString.toString(self, new LinkedHashSet<TypeUsage>());
    }

    private static String toString(TypeUsage self, Set<TypeUsage> touchedTypes) {
        String representation = self.getRawType().getSimpleName();
        if (touchedTypes.contains(self)) {
            if (self.isTypeVariableOrWildcard()) {
                return self.getTypeVariable();
            }
            return representation;
        }
        touchedTypes.add(self);
        if (self.isGeneric()) {
            representation = String.format("%s<%s>", representation, TypeUsageToString.toStringTypeArguments(self, touchedTypes));
        }
        if (self.isArray()) {
            representation = String.format("%s[]", TypeUsageToString.toString((TypeUsage)self.getComponentType().get(), touchedTypes));
        }
        if (self.isTypeVariableOrWildcard()) {
            representation = TypeUsageToString.toStringTypeVariable(self, touchedTypes);
        } else if (!self.getAnnotations().isEmpty()) {
            representation = String.format("%s %s", TypeUsageToString.toStringAnnotations(self), representation);
        }
        if (self.isNullable()) {
            representation = representation + "?";
        }
        return representation;
    }

    private static String toStringTypeArguments(TypeUsage self, Set<TypeUsage> touchedTypes) {
        return self.getTypeArguments().stream().map(typeUsage -> TypeUsageToString.toString(typeUsage, touchedTypes)).collect(Collectors.joining(", "));
    }

    private static String toStringAnnotations(TypeUsage self) {
        return self.getAnnotations().stream().map(Annotation::toString).collect(Collectors.joining(" "));
    }

    private static String toStringTypeVariable(TypeUsage self, Set<TypeUsage> touchedTypes) {
        String representation = self.getTypeVariable();
        if (TypeUsageToString.hasUpperBoundBeyondObject(self)) {
            representation = representation + String.format(" extends %s", TypeUsageToString.toStringUpperBound(self, touchedTypes));
        }
        if (TypeUsageToString.hasLowerBounds(self)) {
            representation = representation + String.format(" super %s", TypeUsageToString.toStringLowerBounds(self, touchedTypes));
        }
        return representation;
    }

    private static boolean hasUpperBoundBeyondObject(TypeUsage self) {
        if (self.getUpperBounds().size() > 1) {
            return true;
        }
        return self.getUpperBounds().size() == 1 && !((TypeUsage)self.getUpperBounds().get(0)).isOfType(Object.class);
    }

    private static boolean hasLowerBounds(TypeUsage self) {
        return self.getLowerBounds().size() > 0;
    }

    private static String toStringLowerBounds(TypeUsage self, Set<TypeUsage> touchedTypes) {
        return self.getLowerBounds().stream().map(typeUsage -> TypeUsageToString.toString(typeUsage, touchedTypes)).collect(Collectors.joining(" & "));
    }

    private static String toStringUpperBound(TypeUsage self, Set<TypeUsage> touchedTypes) {
        return self.getUpperBounds().stream().map(typeUsage -> TypeUsageToString.toString(typeUsage, touchedTypes)).collect(Collectors.joining(" & "));
    }
}

