/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.web;

import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.providers.ArbitraryProvider;
import net.jqwik.api.providers.TypeUsage;
import net.jqwik.web.api.Email;
import net.jqwik.web.api.EmailArbitrary;
import net.jqwik.web.api.Web;

public class EmailArbitraryProvider
implements ArbitraryProvider {
    public boolean canProvideFor(TypeUsage targetType) {
        return targetType.isAssignableFrom(String.class) && targetType.findAnnotation(Email.class).isPresent();
    }

    public Set<Arbitrary<?>> provideFor(TypeUsage targetType, ArbitraryProvider.SubtypeProvider subtypeProvider) {
        Optional optionalEmail = targetType.findAnnotation(Email.class);
        return optionalEmail.map(email -> {
            EmailArbitrary emailArbitrary = Web.emails();
            if (email.quotedLocalPart()) {
                emailArbitrary = emailArbitrary.allowQuotedLocalPart();
            }
            if (email.ipv4Host()) {
                emailArbitrary = emailArbitrary.allowIpv4Host();
            }
            if (email.ipv6Host()) {
                emailArbitrary = emailArbitrary.allowIpv6Host();
            }
            return Collections.singleton(emailArbitrary);
        }).orElse(Collections.emptySet());
    }

    public int priority() {
        return 5;
    }
}

