/*
 * Decompiled with CFR 0.152.
 */
package net.ltgt.resteasy.client.okhttp3;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import okhttp3.Headers;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okio.Buffer;
import okio.BufferedSink;
import org.jboss.resteasy.client.jaxrs.ClientHttpEngine;
import org.jboss.resteasy.client.jaxrs.internal.ClientInvocation;
import org.jboss.resteasy.client.jaxrs.internal.ClientResponse;
import org.jboss.resteasy.util.CaseInsensitiveMap;

public class OkHttpClientEngine
implements ClientHttpEngine {
    private final OkHttpClient client;
    private SSLContext sslContext;

    public OkHttpClientEngine(OkHttpClient client) {
        this.client = client;
    }

    public SSLContext getSslContext() {
        return this.sslContext;
    }

    public void setSslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
    }

    public HostnameVerifier getHostnameVerifier() {
        return this.client.hostnameVerifier();
    }

    public ClientResponse invoke(ClientInvocation request) {
        Response response;
        Request req = this.createRequest(request);
        try {
            response = this.client.newCall(req).execute();
        }
        catch (IOException e) {
            throw new ProcessingException("Unable to invoke request", (Throwable)e);
        }
        return this.createResponse(request, response);
    }

    private Request createRequest(ClientInvocation request) {
        Request.Builder builder = new Request.Builder().method(request.getMethod(), this.createRequestBody(request)).url(request.getUri().toString());
        for (Map.Entry header : request.getHeaders().asMap().entrySet()) {
            String headerName = (String)header.getKey();
            for (String headerValue : (List)header.getValue()) {
                builder.addHeader(headerName, headerValue);
            }
        }
        return builder.build();
    }

    private RequestBody createRequestBody(ClientInvocation request) {
        if (request.getEntity() == null) {
            return null;
        }
        final Buffer buffer = new Buffer();
        try {
            request.writeRequestBody(buffer.outputStream());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        MediaType mediaType = request.getHeaders().getMediaType();
        final okhttp3.MediaType contentType = mediaType == null ? null : okhttp3.MediaType.parse((String)mediaType.toString());
        return new RequestBody(){

            public long contentLength() throws IOException {
                return buffer.size();
            }

            public okhttp3.MediaType contentType() {
                return contentType;
            }

            public void writeTo(BufferedSink sink) throws IOException {
                buffer.copyTo(sink.buffer(), 0L, buffer.size());
            }
        };
    }

    private ClientResponse createResponse(ClientInvocation request, final Response response) {
        ClientResponse clientResponse = new ClientResponse(request.getClientConfiguration()){
            private InputStream stream;

            protected InputStream getInputStream() {
                if (this.stream == null) {
                    this.stream = response.body().byteStream();
                }
                return this.stream;
            }

            protected void setInputStream(InputStream is) {
                this.stream = is;
            }

            public void releaseConnection() throws IOException {
                Throwable primaryExc = null;
                try {
                    if (this.stream != null) {
                        this.stream.close();
                    }
                }
                catch (Throwable t) {
                    primaryExc = t;
                    throw t;
                }
                finally {
                    if (primaryExc != null) {
                        try {
                            response.body().close();
                        }
                        catch (Throwable suppressedExc) {
                            primaryExc.addSuppressed(suppressedExc);
                        }
                    } else {
                        response.body().close();
                    }
                }
            }
        };
        clientResponse.setStatus(response.code());
        clientResponse.setHeaders(this.transformHeaders(response.headers()));
        return clientResponse;
    }

    private MultivaluedMap<String, String> transformHeaders(Headers headers) {
        CaseInsensitiveMap ret = new CaseInsensitiveMap();
        int l = headers.size();
        for (int i = 0; i < l; ++i) {
            ret.add((Object)headers.name(i), (Object)headers.value(i));
        }
        return ret;
    }

    public void close() {
    }
}

