/*
 * Decompiled with CFR 0.152.
 */
package org.mabb.fontverter.eot;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.mabb.fontverter.FVFont;
import org.mabb.fontverter.FontNotSupportedException;
import org.mabb.fontverter.FontProperties;
import org.mabb.fontverter.FontVerter;
import org.mabb.fontverter.converter.EotToOpenTypeConverter;
import org.mabb.fontverter.converter.FontConverter;
import org.mabb.fontverter.converter.IdentityConverter;
import org.mabb.fontverter.eot.EotHeader;
import org.mabb.fontverter.io.DataTypeBindingDeserializer;
import org.mabb.fontverter.io.DataTypeSerializerException;
import org.mabb.fontverter.io.FontDataInput;
import org.mabb.fontverter.io.FontDataOutputStream;
import org.mabb.fontverter.io.LittleEndianInputStream;
import org.mabb.fontverter.opentype.OpenTypeFont;
import org.mabb.fontverter.validator.RuleValidator;

public class EotFont
implements FVFont {
    private EotHeader header = new EotHeader();
    private OpenTypeFont font;

    @Override
    public byte[] getData() throws IOException {
        this.normalize();
        FontDataOutputStream os = new FontDataOutputStream();
        os.write(this.header.getData());
        if (this.font == null) {
            throw new IOException("Embedded font is not set");
        }
        os.write(this.font.getData());
        byte[] data = os.toByteArray();
        os.close();
        return data;
    }

    @Override
    public void normalize() throws IOException {
        this.header.fontDataSize = this.font.getData().length;
        this.header.eotSize = this.header.fontDataSize + (long)this.header.getData().length;
    }

    @Override
    public boolean detectFormat(byte[] fontFile) {
        try {
            LittleEndianInputStream data = new LittleEndianInputStream(fontFile);
            DataTypeBindingDeserializer deserializer = new DataTypeBindingDeserializer();
            this.header = (EotHeader)deserializer.deserialize((FontDataInput)data, EotHeader.class);
            return this.header.isValid();
        }
        catch (DataTypeSerializerException e) {
            return false;
        }
    }

    @Override
    public void read(byte[] fontFile) throws IOException {
        LittleEndianInputStream data = new LittleEndianInputStream(fontFile);
        DataTypeBindingDeserializer deserializer = new DataTypeBindingDeserializer();
        this.header = (EotHeader)deserializer.deserialize((FontDataInput)data, EotHeader.class);
        byte[] fontData = data.readBytes((int)this.header.fontDataSize);
        this.font = (OpenTypeFont)FontVerter.readFont(fontData);
    }

    @Override
    public FontConverter createConverterForType(FontVerter.FontFormat fontFormat) throws FontNotSupportedException {
        if (fontFormat == FontVerter.FontFormat.OTF) {
            return new EotToOpenTypeConverter();
        }
        if (fontFormat == FontVerter.FontFormat.EOT) {
            return new IdentityConverter();
        }
        throw new FontNotSupportedException("");
    }

    @Override
    public String getName() {
        return this.header.getFullName();
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public List<RuleValidator.FontValidatorError> getValidationErrors() {
        return new ArrayList<RuleValidator.FontValidatorError>();
    }

    @Override
    public FontProperties getProperties() {
        FontProperties properties = new FontProperties();
        properties.setCssFontFaceFormat("embedded-opentype");
        properties.setFileEnding("EOT");
        properties.setMimeType("application/vnd.ms-fontobject");
        properties.setFullName(this.header.getFullName());
        properties.setFamily(this.header.getFamilyName());
        properties.setVersion(this.header.getVersionName());
        properties.setName(this.header.getFullName());
        properties.setSubFamilyName(this.header.getStyleName());
        return properties;
    }

    public EotHeader getHeader() {
        return this.header;
    }

    public OpenTypeFont getEmbeddedFont() {
        return this.font;
    }

    public void setFont(OpenTypeFont font) {
        this.font = font;
    }
}

