/*
 * Decompiled with CFR 0.152.
 */
package org.mabb.fontverter.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.apache.commons.io.EndianUtils;
import org.mabb.fontverter.io.FontDataInput;
import org.mabb.fontverter.io.FontDataInputStream;
import org.mabb.fontverter.io.FontDataOutputStream;

public class LittleEndianInputStream
extends FilterInputStream
implements FontDataInput {
    Charset encoding = FontDataOutputStream.OPEN_TYPE_CHARSET;

    public LittleEndianInputStream(byte[] data) {
        super(new FontDataInputStream.SeekableByteArrayInputStream(data));
    }

    @Override
    public long readUnsignedInt() throws IOException {
        return EndianUtils.readSwappedUnsignedInteger((InputStream)this);
    }

    @Override
    public String readString(int length) throws IOException {
        return null;
    }

    @Override
    public byte[] readBytes(int length) throws IOException {
        byte[] bytes = new byte[length];
        for (int i = 0; i < length; ++i) {
            bytes[i] = (byte)this.in.read();
        }
        return bytes;
    }

    @Override
    public void seek(int offset) {
    }

    @Override
    public int readUIntBase128() throws IOException {
        return 0;
    }

    @Override
    public float readFixed32() throws IOException {
        return 0.0f;
    }

    @Override
    public int getPosition() {
        return 0;
    }

    @Override
    public int[] readSplitBits(int numUpperBits) throws IOException {
        return new int[0];
    }

    @Override
    public int[] readUnsignedShortArray(int length) throws IOException {
        return new int[0];
    }

    @Override
    public void readFully(byte[] b) throws IOException {
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
    }

    @Override
    public int skipBytes(int n) throws IOException {
        return 0;
    }

    @Override
    public boolean readBoolean() throws IOException {
        return false;
    }

    @Override
    public byte readByte() throws IOException {
        return (byte)this.in.read();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return 0;
    }

    @Override
    public short readShort() throws IOException {
        return EndianUtils.readSwappedShort((InputStream)this);
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return EndianUtils.readSwappedUnsignedShort((InputStream)this);
    }

    @Override
    public char readChar() throws IOException {
        return '\u0000';
    }

    @Override
    public int readInt() throws IOException {
        return 0;
    }

    @Override
    public long readLong() throws IOException {
        return 0L;
    }

    @Override
    public float readFloat() throws IOException {
        return 0.0f;
    }

    @Override
    public double readDouble() throws IOException {
        return 0.0;
    }

    @Override
    public String readLine() throws IOException {
        return null;
    }

    @Override
    public String readUTF() throws IOException {
        return null;
    }
}

