/*
 * Decompiled with CFR 0.152.
 */
package net.masterthought.cucumber.json;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.time.LocalDateTime;
import net.masterthought.cucumber.Configuration;
import net.masterthought.cucumber.json.Feature;
import net.masterthought.cucumber.json.Hook;
import net.masterthought.cucumber.json.Step;
import net.masterthought.cucumber.json.Tag;
import net.masterthought.cucumber.json.deserializers.TagsDeserializer;
import net.masterthought.cucumber.json.support.Durationable;
import net.masterthought.cucumber.json.support.Status;
import net.masterthought.cucumber.json.support.StatusCounter;
import net.masterthought.cucumber.util.Util;
import org.apache.commons.lang.StringUtils;

public class Element
implements Durationable {
    private final String id;
    private final String name;
    private final String type;
    private final String description;
    private final String keyword;
    private final Integer line = null;
    @JsonProperty(value="start_timestamp")
    private final LocalDateTime startTime = null;
    private final Step[] steps = new Step[0];
    private final Hook[] before = new Hook[0];
    private final Hook[] after = new Hook[0];
    @JsonDeserialize(using=TagsDeserializer.class)
    private final Tag[] tags = new Tag[0];
    private static final String SCENARIO_TYPE = "scenario";
    private static final String BACKGROUND_TYPE = "background";
    private Status elementStatus;
    private Status beforeStatus;
    private Status afterStatus;
    private Status stepsStatus;
    private Feature feature;
    private long duration;

    public Element() {
        this.id = null;
        this.name = null;
        this.type = null;
        this.description = null;
        this.keyword = null;
    }

    public Step[] getSteps() {
        return this.steps;
    }

    public Hook[] getBefore() {
        return this.before;
    }

    public Hook[] getAfter() {
        return this.after;
    }

    public Tag[] getTags() {
        return this.tags;
    }

    public Status getStatus() {
        return this.elementStatus;
    }

    public Status getBeforeStatus() {
        return this.beforeStatus;
    }

    public Status getAfterStatus() {
        return this.afterStatus;
    }

    public Status getStepsStatus() {
        return this.stepsStatus;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getKeyword() {
        return this.keyword;
    }

    public LocalDateTime getStartTime() {
        return this.startTime;
    }

    public Integer getLine() {
        return this.line;
    }

    public String getType() {
        return this.type;
    }

    public String getDescription() {
        return StringUtils.defaultString((String)this.description);
    }

    public boolean isScenario() {
        return SCENARIO_TYPE.equalsIgnoreCase(this.type);
    }

    public boolean isBackground() {
        return BACKGROUND_TYPE.equalsIgnoreCase(this.type);
    }

    public Feature getFeature() {
        return this.feature;
    }

    @Override
    public long getDuration() {
        return this.duration;
    }

    @Override
    public String getFormattedDuration() {
        return Util.formatDuration(this.duration);
    }

    public void setMetaData(Feature feature, Configuration configuration) {
        this.feature = feature;
        for (Step step : this.steps) {
            step.setMetaData();
        }
        this.beforeStatus = new StatusCounter(this.before, configuration.getNotFailingStatuses()).getFinalStatus();
        this.afterStatus = new StatusCounter(this.after, configuration.getNotFailingStatuses()).getFinalStatus();
        this.stepsStatus = new StatusCounter(this.steps, configuration.getNotFailingStatuses()).getFinalStatus();
        this.elementStatus = this.calculateElementStatus();
        this.calculateDuration();
    }

    private Status calculateElementStatus() {
        StatusCounter statusCounter = new StatusCounter();
        statusCounter.incrementFor(this.stepsStatus);
        statusCounter.incrementFor(this.beforeStatus);
        statusCounter.incrementFor(this.afterStatus);
        return statusCounter.getFinalStatus();
    }

    private void calculateDuration() {
        for (Step step : this.steps) {
            this.duration += step.getResult().getDuration();
        }
    }
}

