/*
 * Decompiled with CFR 0.152.
 */
package net.minidev.json.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import net.minidev.json.actions.path.DotDelimiter;
import net.minidev.json.actions.path.PathDelimiter;
import net.minidev.json.actions.traverse.JSONTraverser;
import net.minidev.json.actions.traverse.LocatePathsJsonAction;

public class PathLocator {
    protected List<String> pathsToFind;
    protected PathDelimiter pathDelimiter = new DotDelimiter().withAcceptDelimiterInNodeName(false);

    public PathLocator(JSONArray pathsToFind) {
        if (pathsToFind == null || pathsToFind.isEmpty()) {
            this.pathsToFind = Collections.emptyList();
        } else {
            this.pathsToFind = new ArrayList<String>();
            for (Object s : pathsToFind) {
                this.pathsToFind.add((String)s);
            }
        }
    }

    public PathLocator(List<String> pathsToFind) {
        this.pathsToFind = pathsToFind == null || pathsToFind.size() == 0 ? Collections.emptyList() : pathsToFind;
    }

    public PathLocator(String ... pathsToFind) {
        this.pathsToFind = pathsToFind == null || pathsToFind.length == 0 ? Collections.emptyList() : Arrays.asList(pathsToFind);
    }

    public PathLocator with(PathDelimiter pathDelimiter) {
        this.pathDelimiter = pathDelimiter;
        return this;
    }

    public List<String> locate(JSONObject object) {
        LocatePathsJsonAction action = new LocatePathsJsonAction(this.pathsToFind, this.pathDelimiter);
        JSONTraverser traversal = new JSONTraverser(action).with(this.pathDelimiter);
        traversal.traverse(object);
        return (List)action.result();
    }
}

