package net.minidev.json.parser;

import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import net.minidev.json.parser.ContainerFactory;

/**
 * Fake Container factory used for JSon check and SaX parsing
 * 
 * @author Uriel Chemouni <uchemouni@gmail.com>
 */
public class FakeContainerFactory implements ContainerFactory {
	public FackList list;
	public FackMap map;

	@Override
	public List<Object> creatArrayContainer() {
		if (list == null)
			list = new FackList();
		return list;
	}

	@Override
	public Map<String, Object> createObjectContainer() {
		if (map == null)
			map = new FackMap();
		return map;
	}

	static class FackMap extends AbstractMap<String, Object> {
		public Object put(String key, Object value) {
			return null;
		}

		@Override
		public Set<java.util.Map.Entry<String, Object>> entrySet() {
			return null;
		}
	}

	static class FackList extends AbstractList<Object> {
		public boolean add(Object e) {
			return false;
		}

		@Override
		public Object get(int index) {
			return null;
		}

		@Override
		public int size() {
			return 0;
		}
	}
}
