/*
 * Decompiled with CFR 0.152.
 */
package net.minidev.json.parser;

import net.minidev.json.parser.ContainerFactory;
import net.minidev.json.parser.ContentHandler;
import net.minidev.json.parser.ContentHandlerDumy;

public class JSONParserBase {
    protected ContainerFactory containerFactory;
    protected MSB sb = new MSB(15);
    protected String xs;
    protected Object xo;
    protected int pos;
    protected static boolean[] stopArray = new boolean[126];
    protected static boolean[] stopKey = new boolean[126];
    protected static boolean[] stopValue = new boolean[126];
    protected static boolean[] stopX = new boolean[126];
    public static final int MODE_PERMISSIVE = -1;
    public static final int MODE_PERMISSIF = -1;
    protected boolean acceptSimpleQuote = true;
    protected boolean acceptNonQuote = true;
    protected boolean acceptNaN = true;
    protected ContentHandler handler = ContentHandlerDumy.HANDLER;
    public static final int MODE_RFC4627 = 0;
    public static final int ACCEPT_SIMPLE_QUOTE = 1;
    public static final int ACCEPT_NON_QUOTE = 2;
    public static final int ACCEPT_NAN = 4;

    public void setHandler(ContentHandler handler) {
        this.handler = handler;
    }

    public JSONParserBase(int permissiveMode) {
        this.acceptNaN = (permissiveMode & 4) > 0;
        this.acceptNonQuote = (permissiveMode & 2) > 0;
        this.acceptSimpleQuote = (permissiveMode & 1) > 0;
    }

    static {
        JSONParserBase.stopKey[58] = true;
        JSONParserBase.stopValue[125] = true;
        JSONParserBase.stopValue[44] = true;
        JSONParserBase.stopArray[93] = true;
        JSONParserBase.stopArray[44] = true;
    }

    public static class MSB {
        char[] b;
        int p;

        public MSB(int size) {
            this.b = new char[size];
            this.p = -1;
        }

        public void append(char c) {
            ++this.p;
            if (this.b.length <= this.p) {
                char[] t = new char[this.b.length * 2 + 1];
                System.arraycopy(this.b, 0, t, 0, this.b.length);
                this.b = t;
            }
            this.b[this.p] = c;
        }

        public String toString() {
            return new String(this.b, 0, this.p + 1);
        }

        public void clear() {
            this.p = -1;
        }
    }
}

