/*
 * Decompiled with CFR 0.152.
 */
package net.minidev.json.parser;

import java.io.IOException;
import java.io.Reader;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import net.minidev.json.parser.ContainerFactory;
import net.minidev.json.parser.JSONParserBase;
import net.minidev.json.parser.ParseException;

public class JSONParserStream
extends JSONParserBase {
    public static final int EOI = -1;
    private int c;
    private Reader in;

    public JSONParserStream() {
        super(-1);
    }

    public JSONParserStream(int permissifMode) {
        super(permissifMode);
    }

    public Object parse(Reader in) throws ParseException, IOException {
        return this.parse(in, ContainerFactory.FACTORY);
    }

    public Object parse(Reader in, ContainerFactory containerFactory) throws ParseException, IOException {
        this.in = in;
        this.containerFactory = containerFactory;
        this.pos = 0;
        this.c = in.read();
        this.handler.startJSON();
        Object result = this.readMain(stopX);
        this.handler.endJSON();
        this.xs = null;
        this.xo = null;
        return result;
    }

    private final void read() throws IOException {
        this.c = this.in.read();
        ++this.pos;
    }

    private List<Object> readArray() throws ParseException, IOException {
        List<Object> obj = this.containerFactory.creatArrayContainer();
        if (this.c != 91) {
            throw new RuntimeException("Internal Error");
        }
        this.read();
        this.handler.startArray();
        block7: while (true) {
            switch (this.c) {
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    this.read();
                    continue block7;
                }
                case 93: {
                    this.read();
                    this.handler.endArray();
                    return obj;
                }
                case 58: 
                case 125: {
                    throw new ParseException(this.pos, 0, Character.valueOf((char)this.c));
                }
                case 44: {
                    this.read();
                    continue block7;
                }
                case -1: {
                    throw new ParseException(this.pos - 1, 3, "EOF");
                }
            }
            obj.add(this.readMain(stopArray));
        }
    }

    private Object readMain(boolean[] stop) throws ParseException, IOException {
        block12: while (true) {
            switch (this.c) {
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    this.read();
                    continue block12;
                }
                case 58: 
                case 93: 
                case 125: {
                    throw new ParseException(this.pos, 0, this.c);
                }
                case 123: {
                    return this.readObject();
                }
                case 91: {
                    return this.readArray();
                }
                case 34: 
                case 39: {
                    this.xs = this.readString();
                    this.handler.primitive(this.xs);
                    return this.xs;
                }
                case 110: {
                    this.xs = this.readNQString(stop);
                    if ("null".equals(this.xs)) {
                        this.handler.primitive(null);
                        return null;
                    }
                    if (!this.acceptNonQuote) {
                        throw new ParseException(this.pos, 1, this.xs);
                    }
                    this.handler.primitive(this.xs);
                    return this.xs;
                }
                case 102: {
                    this.xs = this.readNQString(stop);
                    if ("false".equals(this.xs)) {
                        this.handler.primitive(Boolean.FALSE);
                        return Boolean.FALSE;
                    }
                    if (!this.acceptNonQuote) {
                        throw new ParseException(this.pos, 1, this.xs);
                    }
                    this.handler.primitive(this.xs);
                    return this.xs;
                }
                case 116: {
                    this.xs = this.readNQString(stop);
                    if ("true".equals(this.xs)) {
                        this.handler.primitive(Boolean.TRUE);
                        return Boolean.TRUE;
                    }
                    if (!this.acceptNonQuote) {
                        throw new ParseException(this.pos, 1, this.xs);
                    }
                    this.handler.primitive(this.xs);
                    return this.xs;
                }
                case 78: {
                    this.xs = this.readNQString(stop);
                    if (!this.acceptNaN) {
                        throw new ParseException(this.pos, 1, this.xs);
                    }
                    if ("NaN".equals(this.xs)) {
                        this.handler.primitive(Float.valueOf(Float.NaN));
                        return Float.valueOf(Float.NaN);
                    }
                    if (!this.acceptNonQuote) {
                        throw new ParseException(this.pos, 1, this.xs);
                    }
                    this.handler.primitive(this.xs);
                    return this.xs;
                }
                case 45: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    this.xo = this.readNumber(stop);
                    this.handler.primitive(this.xo);
                    return this.xo;
                }
            }
            break;
        }
        this.xs = this.readNQString(stop);
        if (!this.acceptNonQuote) {
            throw new ParseException(this.pos, 1, this.xs);
        }
        this.handler.primitive(this.xs);
        return this.xs;
    }

    private String readNQString(boolean[] stop) throws IOException {
        this.sb.clear();
        this.skipNQString(stop);
        return this.sb.toString().trim();
    }

    private Object readNumber(boolean[] stop) throws ParseException, IOException {
        this.sb.clear();
        this.sb.append((char)this.c);
        this.read();
        this.skipDigits();
        if (this.c != 46 && this.c != 69 && this.c != 101) {
            this.skipSpace();
            if (!stop[this.c]) {
                this.skipNQString(stop);
                this.xs = this.sb.toString().trim();
                if (!this.acceptNonQuote) {
                    throw new ParseException(this.pos, 1, this.xs);
                }
                return this.xs;
            }
            this.xs = this.sb.toString().trim();
            if (this.xs.length() > 20) {
                return new BigInteger(this.xs);
            }
            try {
                long v = Long.parseLong(this.xs);
                if (v >= Integer.MIN_VALUE && v <= Integer.MAX_VALUE) {
                    return (int)v;
                }
                return v;
            }
            catch (NumberFormatException e) {
                return new BigInteger(this.xs);
            }
        }
        if (this.c == 46) {
            this.sb.append((char)this.c);
            this.read();
            this.skipDigits();
        }
        if (this.c != 69 && this.c != 101) {
            this.skipSpace();
            if (!stop[this.c]) {
                this.skipNQString(stop);
                this.xs = this.sb.toString().trim();
                if (!this.acceptNonQuote) {
                    throw new ParseException(this.pos, 1, this.xs);
                }
                return this.xs;
            }
            String num = this.sb.toString().trim();
            return Double.parseDouble(num);
        }
        this.sb.append('E');
        this.read();
        if (this.c == 43 || this.c == 45 || this.c >= 48 && this.c <= 57) {
            this.sb.append((char)this.c);
            this.read();
            this.skipDigits();
            this.skipSpace();
            if (!stop[this.c]) {
                this.skipNQString(stop);
                String text = this.sb.toString().trim();
                if (!this.acceptNonQuote) {
                    throw new ParseException(this.pos, 1, text);
                }
                return text;
            }
            return Double.parseDouble(this.sb.toString().trim());
        }
        this.skipNQString(stop);
        String text = this.sb.toString().trim();
        if (!this.acceptNonQuote) {
            throw new ParseException(this.pos, 1, text);
        }
        return text;
    }

    private Map<String, Object> readObject() throws ParseException, IOException {
        Map<String, Object> obj = this.containerFactory.createObjectContainer();
        if (this.c != 123) {
            throw new RuntimeException("Internal Error");
        }
        this.handler.startObject();
        block6: while (true) {
            String key;
            this.read();
            switch (this.c) {
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    continue block6;
                }
                case 58: 
                case 91: 
                case 93: 
                case 123: {
                    throw new ParseException(this.pos, 0, this.c);
                }
                case 125: {
                    this.read();
                    this.handler.endObject();
                    return obj;
                }
                case 44: {
                    continue block6;
                }
            }
            if (this.c == 34 || this.c == 39) {
                key = this.readString();
            } else {
                key = this.readNQString(stopKey);
                if (!this.acceptNonQuote) {
                    throw new ParseException(this.pos, 1, key);
                }
            }
            this.handler.startObjectEntry(key);
            while (this.c != 58 && this.c != -1) {
                this.read();
            }
            if (this.c == -1) {
                throw new ParseException(this.pos - 1, 3, null);
            }
            this.read();
            obj.put(key, this.readMain(stopValue));
            this.handler.endObjectEntry();
            if (this.c == 125) break;
        }
        this.read();
        this.handler.endObject();
        return obj;
    }

    private String readString() throws ParseException, IOException {
        if (!this.acceptSimpleQuote && this.c == 39) {
            throw new ParseException(this.pos, 0, this.c);
        }
        this.sb.clear();
        char sep = (char)this.c;
        block18: while (true) {
            this.read();
            switch (this.c) {
                case -1: {
                    throw new ParseException(this.pos - 1, 3, null);
                }
                case 34: 
                case 39: {
                    if (sep == this.c) {
                        this.read();
                        return this.sb.toString();
                    }
                    this.sb.append((char)this.c);
                    continue block18;
                }
                case 92: {
                    this.read();
                    switch (this.c) {
                        case 116: {
                            this.sb.append('\t');
                            continue block18;
                        }
                        case 110: {
                            this.sb.append('\n');
                            continue block18;
                        }
                        case 114: {
                            this.sb.append('\r');
                            continue block18;
                        }
                        case 102: {
                            this.sb.append('\f');
                            continue block18;
                        }
                        case 98: {
                            this.sb.append('\b');
                            continue block18;
                        }
                        case 92: {
                            this.sb.append('\\');
                            continue block18;
                        }
                        case 47: {
                            this.sb.append('/');
                            continue block18;
                        }
                        case 39: {
                            this.sb.append('\'');
                            continue block18;
                        }
                        case 34: {
                            this.sb.append('\"');
                            continue block18;
                        }
                        case 117: {
                            this.sb.append(this.readUnicode());
                            continue block18;
                        }
                    }
                    continue block18;
                }
                case 8: 
                case 9: 
                case 10: 
                case 12: 
                case 13: {
                    continue block18;
                }
            }
            this.sb.append((char)this.c);
        }
    }

    private char readUnicode() throws ParseException, IOException {
        int value = 0;
        for (int i = 0; i < 4; ++i) {
            value *= 16;
            this.read();
            if (this.c >= 48 && this.c <= 57) {
                value += this.c - 48;
                continue;
            }
            if (this.c >= 65 && this.c <= 70) {
                value += this.c - 65 + 10;
                continue;
            }
            if (this.c >= 97 && this.c <= 102) {
                value += this.c - 97 + 10;
                continue;
            }
            if (this.c == -1) {
                throw new ParseException(this.pos, 3, "EOF");
            }
            throw new ParseException(this.pos, 4, this.c);
        }
        return (char)value;
    }

    private void skipDigits() throws IOException {
        while (this.c != -1) {
            if (this.c < 48 || this.c > 57) {
                return;
            }
            this.sb.append((char)this.c);
            this.read();
        }
        return;
    }

    private void skipNQString(boolean[] stop) throws IOException {
        while (this.c != -1) {
            if (this.c >= 0 && this.c <= 125 && stop[this.c]) {
                return;
            }
            this.sb.append((char)this.c);
            this.read();
        }
        return;
    }

    private void skipSpace() throws IOException {
        while (this.c != -1) {
            if (this.c != 32 && this.c != 13 && this.c != 9 && this.c != 10) {
                return;
            }
            this.sb.append((char)this.c);
            this.read();
        }
        return;
    }
}

