/*
 * Decompiled with CFR 0.152.
 */
package net.minidev.json.parser;

import java.io.InputStream;
import java.io.Reader;
import net.minidev.json.mapper.AMapper;
import net.minidev.json.mapper.Mapper;
import net.minidev.json.parser.JSONParserByteArray;
import net.minidev.json.parser.JSONParserInputStream;
import net.minidev.json.parser.JSONParserReader;
import net.minidev.json.parser.JSONParserString;
import net.minidev.json.parser.ParseException;

public class JSONParser {
    public static final int ACCEPT_SIMPLE_QUOTE = 1;
    public static final int ACCEPT_NON_QUOTE = 2;
    public static final int ACCEPT_NAN = 4;
    public static final int IGNORE_CONTROL_CHAR = 8;
    public static final int USE_INTEGER_STORAGE = 16;
    public static final int ACCEPT_LEADING_ZERO = 32;
    public static final int ACCEPT_USELESS_COMMA = 64;
    public static final int USE_HI_PRECISION_FLOAT = 128;
    public static final int ACCEPT_TAILLING_DATA = 256;
    public static final int MODE_PERMISSIVE = -1;
    public static final int MODE_RFC4627 = 144;
    public static final int MODE_JSON_SIMPLE = 192;
    public static int DEFAULT_PERMISSIVE_MODE = System.getProperty("JSON_SMART_SIMPLE") != null ? 192 : -1;
    private int mode;
    private JSONParserInputStream pBinStream;
    private JSONParserByteArray pBytes;
    private JSONParserReader pStream;
    private JSONParserString pString;

    private JSONParserReader getPStream() {
        if (this.pStream == null) {
            this.pStream = new JSONParserReader(this.mode);
        }
        return this.pStream;
    }

    private JSONParserInputStream getPBinStream() {
        if (this.pBinStream == null) {
            this.pBinStream = new JSONParserInputStream(this.mode);
        }
        return this.pBinStream;
    }

    private JSONParserString getPString() {
        if (this.pString == null) {
            this.pString = new JSONParserString(this.mode);
        }
        return this.pString;
    }

    private JSONParserByteArray getPBytes() {
        if (this.pBytes == null) {
            this.pBytes = new JSONParserByteArray(this.mode);
        }
        return this.pBytes;
    }

    public JSONParser() {
        this.mode = DEFAULT_PERMISSIVE_MODE;
    }

    public JSONParser(int permissifMode) {
        this.mode = permissifMode;
    }

    public Object parse(byte[] in) throws ParseException {
        return this.getPBytes().parse(in);
    }

    public <T> T parse(byte[] in, AMapper<T> mapper) throws ParseException {
        return this.getPBytes().parse(in, mapper);
    }

    public <T> T parse(byte[] in, Class<T> mapTo) throws ParseException {
        return this.getPBytes().parse(in, Mapper.getMapper(mapTo));
    }

    public Object parse(InputStream in) throws ParseException {
        return this.getPBinStream().parse(in);
    }

    public <T> T parse(InputStream in, AMapper<T> mapper) throws ParseException {
        return this.getPBinStream().parse(in, mapper);
    }

    public <T> T parse(InputStream in, Class<T> mapTo) throws ParseException {
        return this.getPBinStream().parse(in, Mapper.getMapper(mapTo));
    }

    public Object parse(Reader in) throws ParseException {
        return this.getPStream().parse(in);
    }

    public <T> T parse(Reader in, AMapper<T> mapper) throws ParseException {
        return this.getPStream().parse(in, mapper);
    }

    public <T> T parse(Reader in, Class<T> mapTo) throws ParseException {
        return this.getPStream().parse(in, Mapper.getMapper(mapTo));
    }

    public Object parse(String in) throws ParseException {
        return this.getPString().parse(in);
    }

    public <T> T parse(String in, AMapper<T> mapper) throws ParseException {
        return this.getPString().parse(in, mapper);
    }

    public <T> T parse(String in, Class<T> mapTo) throws ParseException {
        return this.getPString().parse(in, Mapper.getMapper(mapTo));
    }
}

