/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.algo;

public enum MemoryUnit {
    BITS{

        @Override
        public long toBits(long a) {
            return a;
        }

        @Override
        public long toBytes(long a) {
            return a / 8L;
        }

        @Override
        public long toLongs(long a) {
            return a / 64L;
        }

        @Override
        public long toCacheLines(long a) {
            return a / 512L;
        }

        @Override
        public long toKilobytes(long a) {
            return a / 8192L;
        }

        @Override
        public long toPages(long a) {
            return a / 32768L;
        }

        @Override
        public long toMegabytes(long a) {
            return a / 0x800000L;
        }

        @Override
        public long toGigabytes(long a) {
            return a / 0x200000000L;
        }

        @Override
        public long convert(long a, MemoryUnit u) {
            return u.toBits(a);
        }

        @Override
        long alignToBytes(long a) {
            return 1.y(a, 8L);
        }

        @Override
        long alignToLongs(long a) {
            return 1.y(a, 64L);
        }

        @Override
        long alignToCacheLines(long a) {
            return 1.y(a, 512L);
        }

        @Override
        long alignToKilobytes(long a) {
            return 1.y(a, 8192L);
        }

        @Override
        long alignToPages(long a) {
            return 1.y(a, 32768L);
        }

        @Override
        long alignToMegabytes(long a) {
            return 1.y(a, 0x800000L);
        }

        @Override
        long alignToGigabytes(long a) {
            return 1.y(a, 0x200000000L);
        }

        @Override
        public long align(long a, MemoryUnit u) {
            return 1.ise(u, this);
        }
    }
    ,
    BYTES{

        @Override
        public long toBits(long a) {
            return 2.x(a, 8L, 0xFFFFFFFFFFFFFFFL);
        }

        @Override
        public long toBytes(long a) {
            return a;
        }

        @Override
        public long toLongs(long a) {
            return a / 8L;
        }

        @Override
        public long toCacheLines(long a) {
            return a / 64L;
        }

        @Override
        public long toKilobytes(long a) {
            return a / 1024L;
        }

        @Override
        public long toPages(long a) {
            return a / 4096L;
        }

        @Override
        public long toMegabytes(long a) {
            return a / 0x100000L;
        }

        @Override
        public long toGigabytes(long a) {
            return a / 0x40000000L;
        }

        @Override
        public long convert(long a, MemoryUnit u) {
            return u.toBytes(a);
        }

        @Override
        long alignToBytes(long a) {
            return 2.ise(this, BYTES);
        }

        @Override
        long alignToLongs(long a) {
            return 2.y(a, 8L);
        }

        @Override
        long alignToCacheLines(long a) {
            return 2.y(a, 64L);
        }

        @Override
        long alignToKilobytes(long a) {
            return 2.y(a, 1024L);
        }

        @Override
        long alignToPages(long a) {
            return 2.y(a, 4096L);
        }

        @Override
        long alignToMegabytes(long a) {
            return 2.y(a, 0x100000L);
        }

        @Override
        long alignToGigabytes(long a) {
            return 2.y(a, 0x40000000L);
        }

        @Override
        public long align(long a, MemoryUnit u) {
            return u.alignToBytes(a);
        }
    }
    ,
    LONGS{

        @Override
        public long toBits(long a) {
            return 3.x(a, 64L, 0x1FFFFFFFFFFFFFFL);
        }

        @Override
        public long toBytes(long a) {
            return 3.x(a, 8L, 0xFFFFFFFFFFFFFFFL);
        }

        @Override
        public long toLongs(long a) {
            return a;
        }

        @Override
        public long toCacheLines(long a) {
            return a / 8L;
        }

        @Override
        public long toKilobytes(long a) {
            return a / 128L;
        }

        @Override
        public long toPages(long a) {
            return a / 512L;
        }

        @Override
        public long toMegabytes(long a) {
            return a / 131072L;
        }

        @Override
        public long toGigabytes(long a) {
            return a / 0x8000000L;
        }

        @Override
        public long convert(long a, MemoryUnit u) {
            return u.toLongs(a);
        }

        @Override
        long alignToBytes(long a) {
            return 3.ise(this, BYTES);
        }

        @Override
        long alignToLongs(long a) {
            return 3.ise(this, LONGS);
        }

        @Override
        long alignToCacheLines(long a) {
            return 3.y(a, 8L);
        }

        @Override
        long alignToKilobytes(long a) {
            return 3.y(a, 128L);
        }

        @Override
        long alignToPages(long a) {
            return 3.y(a, 512L);
        }

        @Override
        long alignToMegabytes(long a) {
            return 3.y(a, 131072L);
        }

        @Override
        long alignToGigabytes(long a) {
            return 3.y(a, 0x8000000L);
        }

        @Override
        public long align(long a, MemoryUnit u) {
            return u.alignToLongs(a);
        }
    }
    ,
    CACHE_LINES{

        @Override
        public long toBits(long a) {
            return 4.x(a, 512L, 0x3FFFFFFFFFFFFFL);
        }

        @Override
        public long toBytes(long a) {
            return 4.x(a, 64L, 0x1FFFFFFFFFFFFFFL);
        }

        @Override
        public long toLongs(long a) {
            return 4.x(a, 8L, 0xFFFFFFFFFFFFFFFL);
        }

        @Override
        public long toCacheLines(long a) {
            return a;
        }

        @Override
        public long toKilobytes(long a) {
            return a / 16L;
        }

        @Override
        public long toPages(long a) {
            return a / 64L;
        }

        @Override
        public long toMegabytes(long a) {
            return a / 16384L;
        }

        @Override
        public long toGigabytes(long a) {
            return a / 0x1000000L;
        }

        @Override
        public long convert(long a, MemoryUnit u) {
            return u.toCacheLines(a);
        }

        @Override
        long alignToBytes(long a) {
            return 4.ise(this, BYTES);
        }

        @Override
        long alignToLongs(long a) {
            return 4.ise(this, LONGS);
        }

        @Override
        long alignToCacheLines(long a) {
            return 4.ise(this, CACHE_LINES);
        }

        @Override
        long alignToKilobytes(long a) {
            return 4.y(a, 16L);
        }

        @Override
        long alignToPages(long a) {
            return 4.y(a, 64L);
        }

        @Override
        long alignToMegabytes(long a) {
            return 4.y(a, 16384L);
        }

        @Override
        long alignToGigabytes(long a) {
            return 4.y(a, 0x1000000L);
        }

        @Override
        public long align(long a, MemoryUnit u) {
            return u.alignToCacheLines(a);
        }
    }
    ,
    KILOBYTES{

        @Override
        public long toBits(long a) {
            return 5.x(a, 8192L, 0x3FFFFFFFFFFFFL);
        }

        @Override
        public long toBytes(long a) {
            return 5.x(a, 1024L, 0x1FFFFFFFFFFFFFL);
        }

        @Override
        public long toLongs(long a) {
            return 5.x(a, 128L, 0xFFFFFFFFFFFFFFL);
        }

        @Override
        public long toCacheLines(long a) {
            return 5.x(a, 16L, 0x7FFFFFFFFFFFFFFL);
        }

        @Override
        public long toKilobytes(long a) {
            return a;
        }

        @Override
        public long toPages(long a) {
            return a / 4L;
        }

        @Override
        public long toMegabytes(long a) {
            return a / 1024L;
        }

        @Override
        public long toGigabytes(long a) {
            return a / 0x100000L;
        }

        @Override
        public long convert(long a, MemoryUnit u) {
            return u.toKilobytes(a);
        }

        @Override
        long alignToBytes(long a) {
            return 5.ise(this, BYTES);
        }

        @Override
        long alignToLongs(long a) {
            return 5.ise(this, LONGS);
        }

        @Override
        long alignToCacheLines(long a) {
            return 5.ise(this, CACHE_LINES);
        }

        @Override
        long alignToKilobytes(long a) {
            return 5.ise(this, KILOBYTES);
        }

        @Override
        long alignToPages(long a) {
            return 5.y(a, 4L);
        }

        @Override
        long alignToMegabytes(long a) {
            return 5.y(a, 1024L);
        }

        @Override
        long alignToGigabytes(long a) {
            return 5.y(a, 0x100000L);
        }

        @Override
        public long align(long a, MemoryUnit u) {
            return u.alignToKilobytes(a);
        }
    }
    ,
    PAGES{

        @Override
        public long toBits(long a) {
            return 6.x(a, 32768L, 0xFFFFFFFFFFFFL);
        }

        @Override
        public long toBytes(long a) {
            return 6.x(a, 4096L, 0x7FFFFFFFFFFFFL);
        }

        @Override
        public long toLongs(long a) {
            return 6.x(a, 512L, 0x3FFFFFFFFFFFFFL);
        }

        @Override
        public long toCacheLines(long a) {
            return 6.x(a, 64L, 0x1FFFFFFFFFFFFFFL);
        }

        @Override
        public long toKilobytes(long a) {
            return 6.x(a, 4L, 0x1FFFFFFFFFFFFFFFL);
        }

        @Override
        public long toPages(long a) {
            return a;
        }

        @Override
        public long toMegabytes(long a) {
            return a / 256L;
        }

        @Override
        public long toGigabytes(long a) {
            return a / 262144L;
        }

        @Override
        public long convert(long a, MemoryUnit u) {
            return u.toPages(a);
        }

        @Override
        long alignToBytes(long a) {
            return 6.ise(this, BYTES);
        }

        @Override
        long alignToLongs(long a) {
            return 6.ise(this, LONGS);
        }

        @Override
        long alignToCacheLines(long a) {
            return 6.ise(this, CACHE_LINES);
        }

        @Override
        long alignToKilobytes(long a) {
            return 6.ise(this, KILOBYTES);
        }

        @Override
        long alignToPages(long a) {
            return 6.ise(this, PAGES);
        }

        @Override
        long alignToMegabytes(long a) {
            return 6.y(a, 256L);
        }

        @Override
        long alignToGigabytes(long a) {
            return 6.y(a, 262144L);
        }

        @Override
        public long align(long a, MemoryUnit u) {
            return u.alignToPages(a);
        }
    }
    ,
    MEGABYTES{

        @Override
        public long toBits(long a) {
            return 7.x(a, 0x800000L, 0xFFFFFFFFFFL);
        }

        @Override
        public long toBytes(long a) {
            return 7.x(a, 0x100000L, 0x7FFFFFFFFFFL);
        }

        @Override
        public long toLongs(long a) {
            return 7.x(a, 131072L, 0x3FFFFFFFFFFFL);
        }

        @Override
        public long toCacheLines(long a) {
            return 7.x(a, 16384L, 0x1FFFFFFFFFFFFL);
        }

        @Override
        public long toKilobytes(long a) {
            return 7.x(a, 1024L, 0x1FFFFFFFFFFFFFL);
        }

        @Override
        public long toPages(long a) {
            return 7.x(a, 256L, 0x7FFFFFFFFFFFFFL);
        }

        @Override
        public long toMegabytes(long a) {
            return a;
        }

        @Override
        public long toGigabytes(long a) {
            return a / 1024L;
        }

        @Override
        public long convert(long a, MemoryUnit u) {
            return u.toMegabytes(a);
        }

        @Override
        long alignToBytes(long a) {
            return 7.ise(this, BYTES);
        }

        @Override
        long alignToLongs(long a) {
            return 7.ise(this, LONGS);
        }

        @Override
        long alignToCacheLines(long a) {
            return 7.ise(this, CACHE_LINES);
        }

        @Override
        long alignToKilobytes(long a) {
            return 7.ise(this, KILOBYTES);
        }

        @Override
        long alignToPages(long a) {
            return 7.ise(this, PAGES);
        }

        @Override
        long alignToMegabytes(long a) {
            return 7.ise(this, MEGABYTES);
        }

        @Override
        long alignToGigabytes(long a) {
            return 7.y(a, 1024L);
        }

        @Override
        public long align(long a, MemoryUnit u) {
            return u.alignToMegabytes(a);
        }
    }
    ,
    GIGABYTES{

        @Override
        public long toBits(long a) {
            return 8.x(a, 0x200000000L, 0x3FFFFFFFL);
        }

        @Override
        public long toBytes(long a) {
            return 8.x(a, 0x40000000L, 0x1FFFFFFFFL);
        }

        @Override
        public long toLongs(long a) {
            return 8.x(a, 0x8000000L, 0xFFFFFFFFFL);
        }

        @Override
        public long toCacheLines(long a) {
            return 8.x(a, 0x1000000L, 0x7FFFFFFFFFL);
        }

        @Override
        public long toKilobytes(long a) {
            return 8.x(a, 0x100000L, 0x7FFFFFFFFFFL);
        }

        @Override
        public long toPages(long a) {
            return 8.x(a, 262144L, 0x1FFFFFFFFFFFL);
        }

        @Override
        public long toMegabytes(long a) {
            return 8.x(a, 1024L, 0x1FFFFFFFFFFFFFL);
        }

        @Override
        public long toGigabytes(long a) {
            return a;
        }

        @Override
        public long convert(long a, MemoryUnit u) {
            return u.toGigabytes(a);
        }

        @Override
        long alignToBytes(long a) {
            return 8.ise(this, BYTES);
        }

        @Override
        long alignToLongs(long a) {
            return 8.ise(this, LONGS);
        }

        @Override
        long alignToCacheLines(long a) {
            return 8.ise(this, CACHE_LINES);
        }

        @Override
        long alignToKilobytes(long a) {
            return 8.ise(this, KILOBYTES);
        }

        @Override
        long alignToPages(long a) {
            return 8.ise(this, PAGES);
        }

        @Override
        long alignToMegabytes(long a) {
            return 8.ise(this, MEGABYTES);
        }

        @Override
        long alignToGigabytes(long a) {
            return 8.ise(this, GIGABYTES);
        }

        @Override
        public long align(long a, MemoryUnit u) {
            return u.alignToGigabytes(a);
        }
    };

    static final long C0 = 1L;
    static final long C1 = 8L;
    static final long C2 = 64L;
    static final long C3 = 512L;
    static final long C4 = 8192L;
    static final long C5 = 32768L;
    static final long C6 = 0x800000L;
    static final long C7 = 0x200000000L;
    static final long MAX = Long.MAX_VALUE;

    static long x(long a, long m, long over) {
        if (a > over) {
            return Long.MAX_VALUE;
        }
        if (a < -over) {
            return Long.MIN_VALUE;
        }
        return a * m;
    }

    static long y(long amount, long align) {
        if (amount == 0L) {
            return 0L;
        }
        long mask = align - 1L ^ 0xFFFFFFFFFFFFFFFFL;
        if (amount > 0L) {
            long filled = amount + align - 1L;
            if (filled > 0L) {
                return filled & mask;
            }
            long maxAlignedLong = Long.MAX_VALUE & mask;
            if (amount <= maxAlignedLong) {
                return maxAlignedLong;
            }
        } else {
            long filled = amount - align + 1L;
            if (filled < 0L) {
                return filled & mask;
            }
            long minAlignedLong = Long.MIN_VALUE & mask;
            if (amount >= minAlignedLong) {
                return minAlignedLong;
            }
        }
        throw new IllegalArgumentException("Couldn't align " + amount + " by " + align);
    }

    static long ise(MemoryUnit unitToAlign, MemoryUnit alignmentUnit) {
        throw new IllegalStateException("Couldn't align " + (Object)((Object)unitToAlign) + " by " + (Object)((Object)alignmentUnit));
    }

    public long convert(long sourceAmount, MemoryUnit sourceUnit) {
        throw new AbstractMethodError();
    }

    public long align(long amountToAlign, MemoryUnit unit) {
        throw new AbstractMethodError();
    }

    public long alignAndConvert(long sourceAmount, MemoryUnit sourceUnit) {
        return this.convert(this.align(sourceAmount, sourceUnit), sourceUnit);
    }

    public long toBits(long amount) {
        throw new AbstractMethodError();
    }

    public long toBytes(long amount) {
        throw new AbstractMethodError();
    }

    public long toLongs(long amount) {
        throw new AbstractMethodError();
    }

    public long toCacheLines(long amount) {
        throw new AbstractMethodError();
    }

    public long toKilobytes(long amount) {
        throw new AbstractMethodError();
    }

    public long toPages(long amount) {
        throw new AbstractMethodError();
    }

    public long toMegabytes(long amount) {
        throw new AbstractMethodError();
    }

    public long toGigabytes(long amount) {
        throw new AbstractMethodError();
    }

    abstract long alignToBytes(long var1);

    abstract long alignToLongs(long var1);

    abstract long alignToCacheLines(long var1);

    abstract long alignToKilobytes(long var1);

    abstract long alignToPages(long var1);

    abstract long alignToMegabytes(long var1);

    abstract long alignToGigabytes(long var1);
}

