/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes.ref;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.charset.StandardCharsets;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.ref.AbstractReference;
import net.openhft.chronicle.bytes.ref.ByteableLongArrayValues;
import net.openhft.chronicle.bytes.util.DecoratedBufferOverflowException;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.annotation.NonNegative;
import net.openhft.chronicle.core.values.LongValue;
import org.jetbrains.annotations.NotNull;

public class TextLongArrayReference
extends AbstractReference
implements ByteableLongArrayValues {
    private static final byte[] SECTION1 = "{ locked: false, capacity: ".getBytes(StandardCharsets.ISO_8859_1);
    private static final byte[] SECTION2 = ", used: ".getBytes(StandardCharsets.ISO_8859_1);
    private static final byte[] SECTION3 = ", values: [ ".getBytes(StandardCharsets.ISO_8859_1);
    private static final byte[] SECTION4 = " ] }\n".getBytes(StandardCharsets.ISO_8859_1);
    private static final byte[] ZERO = "00000000000000000000".getBytes(StandardCharsets.ISO_8859_1);
    private static final byte[] SEP = ", ".getBytes(StandardCharsets.ISO_8859_1);
    private static final int DIGITS = ZERO.length;
    private static final int CAPACITY = SECTION1.length;
    private static final int USED = CAPACITY + DIGITS + SECTION2.length;
    private static final int VALUES = USED + DIGITS + SECTION3.length;
    private static final int VALUE_SIZE = DIGITS + SEP.length;
    private static final int LOCK_OFFSET = 10;
    private static final int FALS = 1936482662;
    private static final int TRU = 1970435104;
    private long length = VALUES;

    public static void write(@NotNull Bytes<?> bytes, @NonNegative long capacity) throws IllegalArgumentException, IllegalStateException, BufferOverflowException, ArithmeticException, BufferUnderflowException {
        long start = bytes.writePosition();
        bytes.write(SECTION1);
        bytes.append(capacity);
        while (bytes.writePosition() - start < (long)(CAPACITY + DIGITS)) {
            bytes.writeUnsignedByte(32);
        }
        bytes.write(SECTION2);
        bytes.write(ZERO);
        bytes.write(SECTION3);
        for (long i = 0L; i < capacity; ++i) {
            if (i > 0L) {
                bytes.appendUtf8(", ");
            }
            bytes.write(ZERO);
        }
        bytes.write(SECTION4);
    }

    public static long peakLength(@NotNull BytesStore bytes, @NonNegative long offset) throws IllegalStateException, BufferUnderflowException {
        return bytes.parseLong(offset + (long)CAPACITY) * (long)VALUE_SIZE - (long)SEP.length + (long)VALUES + (long)SECTION4.length;
    }

    public long getUsed() throws IllegalStateException {
        try {
            return this.bytes.parseLong((long)USED + this.offset);
        }
        catch (NullPointerException e) {
            this.throwExceptionIfClosed();
            throw e;
        }
        catch (BufferUnderflowException e) {
            throw new AssertionError((Object)e);
        }
    }

    public void setUsed(long used) throws IllegalStateException {
        try {
            this.bytes.append((long)VALUES + this.offset, used, DIGITS);
        }
        catch (NullPointerException e) {
            this.throwExceptionIfClosed();
            throw e;
        }
        catch (IllegalArgumentException | BufferOverflowException e) {
            throw new AssertionError((Object)e);
        }
    }

    public void setMaxUsed(long usedAtLeast) throws IllegalStateException {
        try {
            while (!this.bytes.compareAndSwapInt(10L + this.offset, 1936482662, 1970435104)) {
            }
            try {
                if (this.getUsed() < usedAtLeast) {
                    this.setUsed(usedAtLeast);
                }
                return;
            }
            finally {
                this.bytes.writeInt(10L + this.offset, 1936482662);
            }
        }
        catch (NullPointerException e) {
            this.throwExceptionIfClosed();
            throw e;
        }
        catch (IllegalStateException | BufferOverflowException e) {
            throw new AssertionError((Object)e);
        }
    }

    public long getCapacity() {
        return (this.length - (long)VALUES) / (long)VALUE_SIZE;
    }

    @Override
    public ByteableLongArrayValues capacity(@NonNegative long arrayLength) {
        BytesStore bytesStore = this.bytesStore();
        long len = this.sizeInBytes(arrayLength);
        if (bytesStore == null) {
            this.length = len;
        } else assert (this.length == len);
        return this;
    }

    public long getValueAt(@NonNegative long index) throws IllegalStateException {
        try {
            return this.bytes.parseLong((long)VALUES + this.offset + index * (long)VALUE_SIZE);
        }
        catch (NullPointerException e) {
            this.throwExceptionIfClosed();
            throw e;
        }
        catch (BufferUnderflowException e) {
            throw new AssertionError((Object)e);
        }
    }

    public void setValueAt(@NonNegative long index, long value) throws IllegalStateException {
        try {
            this.bytes.append((long)VALUES + this.offset + index * (long)VALUE_SIZE, value, DIGITS);
        }
        catch (NullPointerException e) {
            this.throwExceptionIfClosed();
            throw e;
        }
        catch (IllegalArgumentException | BufferOverflowException e) {
            throw new AssertionError((Object)e);
        }
    }

    public void bindValueAt(@NonNegative long index, LongValue value) {
        throw new UnsupportedOperationException("todo");
    }

    public long getVolatileValueAt(@NonNegative long index) throws IllegalStateException {
        OS.memory().loadFence();
        return this.getValueAt(index);
    }

    public void setOrderedValueAt(@NonNegative long index, long value) throws IllegalStateException {
        this.setValueAt(index, value);
        OS.memory().storeFence();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean compareAndSet(@NonNegative long index, long expected, long value) throws IllegalStateException {
        boolean bl;
        if (!this.bytes.compareAndSwapInt(10L + this.offset, 1936482662, 1970435104)) {
            return false;
        }
        boolean ret = false;
        try {
            if (this.getVolatileValueAt(index) == expected) {
                this.setOrderedValueAt(index, value);
                ret = true;
            }
            bl = ret;
        }
        catch (Throwable throwable) {
            try {
                this.bytes.writeInt(10L + this.offset, 1936482662);
                throw throwable;
            }
            catch (NullPointerException e) {
                this.throwExceptionIfClosed();
                throw e;
            }
            catch (BufferOverflowException e) {
                throw new AssertionError((Object)e);
            }
        }
        this.bytes.writeInt(10L + this.offset, 1936482662);
        return bl;
    }

    @Override
    public void bytesStore(@NotNull BytesStore bytes, @NonNegative long offset, @NonNegative long length) throws IllegalStateException, BufferOverflowException, IllegalArgumentException {
        this.throwExceptionIfClosedInSetter();
        long peakLength = 0L;
        try {
            peakLength = TextLongArrayReference.peakLength(bytes, offset);
        }
        catch (BufferUnderflowException e) {
            throw new DecoratedBufferOverflowException(e.toString());
        }
        if (length != peakLength) {
            throw new IllegalArgumentException(length + " != " + peakLength);
        }
        super.bytesStore(bytes, offset, length);
        this.length = length;
    }

    public boolean isNull() {
        return this.bytes == null;
    }

    public void reset() throws IllegalStateException {
        this.throwExceptionIfClosedInSetter();
        this.bytes = null;
        this.offset = 0L;
        this.length = 0L;
    }

    @Override
    public long maxSize() {
        return this.length;
    }

    @NotNull
    public String toString() {
        if (this.bytes == null) {
            return "LongArrayTextReference{bytes=null, offset=" + this.offset + ", length=" + this.length + '}';
        }
        try {
            return "value: " + this.getValueAt(0L) + " ...";
        }
        catch (Exception e) {
            return e.toString();
        }
    }

    @Override
    public long sizeInBytes(@NonNegative long capacity) {
        return capacity * (long)VALUE_SIZE + (long)VALUES + (long)SECTION3.length - (long)SEP.length;
    }
}

