/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.BufferUnderflowException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.openhft.chronicle.bytes.BytesIn;
import net.openhft.chronicle.bytes.BytesMarshallable;
import net.openhft.chronicle.bytes.BytesParselet;
import net.openhft.chronicle.bytes.MethodEncoder;
import net.openhft.chronicle.bytes.MethodEncoderLookup;
import net.openhft.chronicle.bytes.MethodReader;
import net.openhft.chronicle.bytes.MethodReaderInterceptorReturns;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.InvalidMarshallableException;
import net.openhft.chronicle.core.io.SimpleCloseable;
import net.openhft.chronicle.core.util.InvocationTargetRuntimeException;
import net.openhft.chronicle.core.util.ObjectUtils;

public class BytesMethodReader
extends SimpleCloseable
implements MethodReader {
    private final BytesIn<?> in;
    private final BytesParselet defaultParselet;
    private final List<Consumer<BytesIn>> methodEncoders = new ArrayList<Consumer<BytesIn>>();
    private final Map<Long, Consumer<BytesIn>> methodEncoderMap = new LinkedHashMap<Long, Consumer<BytesIn>>();

    public BytesMethodReader(BytesIn<?> in, BytesParselet defaultParselet, MethodEncoderLookup methodEncoderLookup, Object[] objects) {
        this.in = in;
        this.defaultParselet = defaultParselet;
        for (Object object : objects) {
            for (Method method : object.getClass().getMethods()) {
                MethodEncoder encoder = methodEncoderLookup.apply(method);
                if (encoder == null) continue;
                this.addEncoder(object, method, encoder);
            }
        }
    }

    private void addEncoder(Object object, Method method, MethodEncoder encoder) {
        Jvm.setAccessible((AccessibleObject)method);
        Class<?>[] parameterTypes = method.getParameterTypes();
        int count = parameterTypes.length;
        BytesMarshallable[][] array = new BytesMarshallable[1][count];
        for (int i = 0; i < count; ++i) {
            array[0][i] = (BytesMarshallable)ObjectUtils.newInstance(parameterTypes[i]);
        }
        Consumer<BytesIn> reader = bytesIn -> {
            try {
                array[0] = (BytesMarshallable[])encoder.decode(array[0], (BytesIn<?>)bytesIn);
                method.invoke(object, array[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | IllegalStateException | InvocationTargetException | BufferUnderflowException | InvalidMarshallableException e) {
                Jvm.warn().on(this.getClass(), "Exception calling " + method + " " + Arrays.toString(array[0]), e);
                bytesIn.readPosition(bytesIn.readLimit());
            }
        };
        long messageId = encoder.messageId();
        if (messageId >= 0L && messageId < 1000L) {
            while ((long)this.methodEncoders.size() <= messageId) {
                this.methodEncoders.add(null);
            }
            this.methodEncoders.set((int)messageId, reader);
        } else {
            this.methodEncoderMap.put(messageId, reader);
        }
    }

    @Override
    public MethodReaderInterceptorReturns methodReaderInterceptorReturns() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean readOne() throws InvocationTargetRuntimeException, IllegalStateException, BufferUnderflowException {
        this.throwExceptionIfClosed();
        if (this.in.readRemaining() < 1L) {
            return false;
        }
        long messageId = this.in.readStopBit();
        Consumer<BytesIn> consumer = messageId >= 0L && messageId < (long)this.methodEncoders.size() ? this.methodEncoders.get((int)messageId) : this.methodEncoderMap.get(messageId);
        if (consumer == null) {
            this.defaultParselet.accept(messageId, this.in);
        } else {
            consumer.accept(this.in);
        }
        return true;
    }

    @Override
    public MethodReader closeIn(boolean closeIn) {
        return this;
    }
}

