/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.io.File;
import java.io.FileNotFoundException;
import net.openhft.chronicle.bytes.AbstractBytes;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.MappedBytesStore;
import net.openhft.chronicle.bytes.MappedFile;
import net.openhft.chronicle.bytes.PageUtil;
import net.openhft.chronicle.bytes.SubBytes;
import net.openhft.chronicle.bytes.VanillaBytes;
import net.openhft.chronicle.bytes.internal.ChunkedMappedBytes;
import net.openhft.chronicle.bytes.internal.SingleMappedBytes;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.annotation.NonNegative;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.io.ClosedIllegalStateException;
import net.openhft.chronicle.core.io.ManagedCloseable;
import net.openhft.chronicle.core.io.Syncable;
import net.openhft.chronicle.core.io.ThreadingIllegalStateException;
import org.jetbrains.annotations.NotNull;

public abstract class MappedBytes
extends AbstractBytes<Void>
implements Closeable,
ManagedCloseable,
Syncable {
    protected static final boolean TRACE = Jvm.getBoolean((String)"trace.mapped.bytes");

    protected MappedBytes() throws ClosedIllegalStateException, ThreadingIllegalStateException {
        this("");
    }

    protected MappedBytes(String name) throws ClosedIllegalStateException, ThreadingIllegalStateException {
        super(BytesStore.empty(), BytesStore.empty().writePosition(), BytesStore.empty().writeLimit(), name);
    }

    @NotNull
    public static MappedBytes singleMappedBytes(@NotNull String filename, @NonNegative long capacity) throws FileNotFoundException, IllegalStateException {
        return MappedBytes.singleMappedBytes(new File(filename), capacity);
    }

    @NotNull
    public static MappedBytes singleMappedBytes(@NotNull File file, @NonNegative long capacity) throws FileNotFoundException {
        return MappedBytes.singleMappedBytes(file, capacity, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static MappedBytes singleMappedBytes(@NotNull File file, @NonNegative long capacity, boolean readOnly) throws FileNotFoundException {
        MappedFile rw = MappedFile.ofSingle(file, capacity, readOnly);
        try {
            SingleMappedBytes singleMappedBytes = new SingleMappedBytes(rw);
            return singleMappedBytes;
        }
        finally {
            rw.release(INIT);
        }
    }

    @NotNull
    public static MappedBytes mappedBytes(@NotNull String filename, @NonNegative long chunkSize) throws FileNotFoundException, ClosedIllegalStateException {
        return MappedBytes.mappedBytes(new File(filename), chunkSize);
    }

    @NotNull
    public static MappedBytes mappedBytes(@NotNull File file, @NonNegative long chunkSize) throws FileNotFoundException, ClosedIllegalStateException {
        return MappedBytes.mappedBytes(file, chunkSize, OS.pageSize());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static MappedBytes mappedBytes(@NotNull File file, @NonNegative long chunkSize, @NonNegative long overlapSize) throws FileNotFoundException, ClosedIllegalStateException {
        MappedFile rw = MappedFile.of(file, chunkSize, overlapSize, false);
        try {
            MappedBytes mappedBytes = MappedBytes.mappedBytes(rw);
            return mappedBytes;
        }
        finally {
            rw.release(INIT);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static MappedBytes mappedBytes(@NotNull File file, @NonNegative long chunkSize, @NonNegative long overlapSize, @NonNegative int pageSize, boolean readOnly) throws FileNotFoundException, ClosedIllegalStateException {
        MappedFile rw = MappedFile.of(file, chunkSize, overlapSize, pageSize, readOnly);
        try {
            MappedBytes mappedBytes = MappedBytes.mappedBytes(rw);
            return mappedBytes;
        }
        finally {
            rw.release(INIT);
        }
    }

    @NotNull
    public static MappedBytes mappedBytes(@NotNull File file, @NonNegative long chunkSize, @NonNegative long overlapSize, boolean readOnly) throws FileNotFoundException, ClosedIllegalStateException {
        return MappedBytes.mappedBytes(file, chunkSize, overlapSize, PageUtil.getPageSize(file.getAbsolutePath()), readOnly);
    }

    @NotNull
    public static MappedBytes mappedBytes(@NotNull MappedFile rw) throws ClosedIllegalStateException {
        return rw.createBytesFor();
    }

    @NotNull
    public static MappedBytes readOnly(@NotNull File file) throws FileNotFoundException, ClosedIllegalStateException, ThreadingIllegalStateException {
        MappedFile mappedFile = MappedFile.readOnly(file);
        try {
            ChunkedMappedBytes chunkedMappedBytes = new ChunkedMappedBytes(mappedFile);
            return chunkedMappedBytes;
        }
        finally {
            mappedFile.release(INIT);
        }
    }

    public abstract boolean isBackingFileReadOnly();

    @Override
    public boolean sharedMemory() {
        return true;
    }

    public abstract void chunkCount(long[] var1);

    public abstract MappedFile mappedFile();

    public void sync() {
        BytesStore bs = this.bytesStore;
        if (bs instanceof MappedBytesStore) {
            MappedBytesStore mbs = (MappedBytesStore)bs;
            mbs.syncUpTo(this.writePosition());
        }
    }

    @Override
    @NotNull
    public Bytes<Void> bytesForRead() throws ClosedIllegalStateException {
        this.throwExceptionIfReleased();
        return this.isClear() ? new VanillaBytes<Void>((BytesStore)this, this.writePosition(), this.bytesStore.writeLimit()) : new SubBytes((BytesStore)this, this.readPosition(), this.readLimit() + this.start());
    }

    @Override
    @NotNull
    public Bytes<Void> bytesForWrite() throws ClosedIllegalStateException {
        this.throwExceptionIfReleased();
        return new VanillaBytes<Void>((BytesStore)this, this.writePosition(), this.writeLimit());
    }
}

