/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes.util;

import java.nio.BufferUnderflowException;
import net.openhft.chronicle.bytes.AppendableUtil;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.UTFDataFormatRuntimeException;
import net.openhft.chronicle.bytes.util.AbstractInterner;
import net.openhft.chronicle.core.annotation.NonNegative;
import net.openhft.chronicle.core.pool.StringBuilderPool;
import net.openhft.chronicle.core.scoped.ScopedResource;
import net.openhft.chronicle.core.scoped.ScopedResourcePool;
import org.jetbrains.annotations.NotNull;

public class UTF8StringInterner
extends AbstractInterner<String> {
    private static final ScopedResourcePool<StringBuilder> SBP = StringBuilderPool.createThreadLocal((int)1);

    public UTF8StringInterner(@NonNegative int capacity) {
        super(capacity);
    }

    @Override
    @NotNull
    protected String getValue(@NotNull BytesStore cs, @NonNegative int length) throws UTFDataFormatRuntimeException, IllegalStateException, BufferUnderflowException {
        try (ScopedResource sbTl = SBP.get();){
            StringBuilder sb = (StringBuilder)sbTl.get();
            AppendableUtil.parseUtf8(cs, sb, true, length);
            String string = sb.toString();
            return string;
        }
    }
}

