/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.pool;

import java.util.stream.Stream;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.util.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringInterner {
    @NotNull
    protected final String[] interner;
    protected final int mask;
    protected final int shift;
    protected boolean toggle = false;

    public StringInterner(int capacity) throws IllegalArgumentException {
        int n = Maths.nextPower2(capacity, 128);
        this.shift = Maths.intLog2(n);
        this.interner = new String[n];
        this.mask = n - 1;
    }

    @Nullable
    public String intern(@Nullable CharSequence cs) {
        if (cs == null) {
            return null;
        }
        if (cs.length() > this.interner.length) {
            return cs.toString();
        }
        int hash = Maths.hash32(cs);
        int h = hash & this.mask;
        String s = this.interner[h];
        if (StringUtils.isEqual(s, cs)) {
            return s;
        }
        int h2 = hash >> this.shift & this.mask;
        String s2 = this.interner[h2];
        if (StringUtils.isEqual(s2, cs)) {
            return s2;
        }
        String s3 = cs.toString();
        this.interner[s == null || s2 != null && this.toggle() ? h : h2] = s3;
        return s3;
    }

    protected boolean toggle() {
        this.toggle = !this.toggle;
        return this.toggle;
    }

    public int valueCount() {
        return (int)Stream.of(this.interner).filter(s -> s != null).count();
    }
}

