/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.pool;

import net.openhft.chronicle.core.ClassLocal;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.util.StringUtils;
import org.jetbrains.annotations.NotNull;

public class EnumInterner<E extends Enum<E>> {
    public static final ClassLocal<EnumInterner> ENUM_INTERNER = ClassLocal.withInitial(EnumInterner::create);
    @NotNull
    private final E[] interner;
    private final int mask;
    private final Class<E> eClass;

    public EnumInterner(Class<E> eClass) {
        this(eClass, 64);
    }

    public EnumInterner(Class<E> eClass, int capacity) {
        this.eClass = eClass;
        int n = Maths.nextPower2(capacity, 16);
        this.interner = new Enum[n];
        this.mask = n - 1;
    }

    @NotNull
    static <V extends Enum<V>> EnumInterner<V> create(Class<?> aClass) {
        Class<?> vClass = aClass;
        return new EnumInterner(vClass);
    }

    public E intern(@NotNull CharSequence cs) {
        int h = Maths.hash32(cs) & this.mask;
        E e = this.interner[h];
        if (e != null && StringUtils.isEqual(((Enum)e).name(), cs)) {
            return e;
        }
        String s2 = cs.toString();
        this.interner[h] = Enum.valueOf(this.eClass, s2);
        return this.interner[h];
    }
}

