/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.time;

import java.util.concurrent.TimeUnit;

@FunctionalInterface
public interface TimeProvider {
    public long currentTimeMillis();

    default public long currentTimeMicros() throws IllegalStateException {
        return this.currentTimeMillis() * 1000L;
    }

    default public long currentTimeNanos() throws IllegalStateException {
        return this.currentTimeMicros() * 1000L;
    }

    @Deprecated
    default public long currentTime(TimeUnit timeUnit) throws IllegalStateException {
        switch (timeUnit) {
            case NANOSECONDS: {
                return this.currentTimeNanos();
            }
            case MICROSECONDS: {
                return this.currentTimeMicros();
            }
            case MILLISECONDS: {
                return this.currentTimeMillis();
            }
        }
        return timeUnit.convert(this.currentTimeNanos(), TimeUnit.NANOSECONDS);
    }
}

