/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.io;

import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.StackTrace;
import net.openhft.chronicle.core.UnsafeMemory;
import net.openhft.chronicle.core.annotation.UsedViaReflection;
import net.openhft.chronicle.core.io.AbstractCloseable;
import net.openhft.chronicle.core.io.ClosedIllegalStateException;
import net.openhft.chronicle.core.io.MonitorReferenceCounted;
import net.openhft.chronicle.core.io.ReferenceChangeListener;
import net.openhft.chronicle.core.io.ReferenceChangeListenerManager;
import net.openhft.chronicle.core.io.ReferenceOwner;

public final class VanillaReferenceCounted
implements MonitorReferenceCounted {
    private static final long VALUE = UnsafeMemory.unsafeObjectFieldOffset(Jvm.getField(VanillaReferenceCounted.class, "value"));
    private final Runnable onRelease;
    private final Class<?> type;
    private final ReferenceChangeListenerManager referenceChangeListeners;
    @UsedViaReflection
    private volatile int value = 1;
    private volatile boolean released = false;
    private boolean unmonitored;
    private StackTrace releasedHere;

    VanillaReferenceCounted(Runnable onRelease, Class<?> type) {
        this.onRelease = onRelease;
        this.type = type;
        this.referenceChangeListeners = new ReferenceChangeListenerManager(this);
    }

    @Override
    public StackTrace createdHere() {
        return null;
    }

    @Override
    public void reserve(ReferenceOwner id) throws ClosedIllegalStateException {
        int v;
        do {
            if ((v = this.value) > 0) continue;
            throw this.newReleasedClosedIllegalStateException();
        } while (!this.valueCompareAndSet(v, v + 1));
        this.referenceChangeListeners.notifyAdded(id);
    }

    @Override
    public void reserveTransfer(ReferenceOwner from, ReferenceOwner to) throws ClosedIllegalStateException {
        this.throwExceptionIfReleased();
        this.referenceChangeListeners.notifyTransferred(from, to);
    }

    @Override
    public boolean tryReserve(ReferenceOwner id) {
        int v;
        do {
            if ((v = this.value) > 0) continue;
            return false;
        } while (!this.valueCompareAndSet(v, v + 1));
        this.referenceChangeListeners.notifyAdded(id);
        return true;
    }

    private boolean valueCompareAndSet(int from, int to) {
        return UnsafeMemory.INSTANCE.compareAndSwapInt(this, VALUE, from, to);
    }

    private int valueGetAndSet(int to) {
        return UnsafeMemory.INSTANCE.getAndSetInt(this, VALUE, to);
    }

    @Override
    public void release(ReferenceOwner id) throws ClosedIllegalStateException {
        block1: {
            int count;
            int v;
            do {
                if ((v = this.value) > 0) continue;
                throw this.newReleasedClosedIllegalStateException();
            } while (!this.valueCompareAndSet(v, count = v - 1));
            this.referenceChangeListeners.notifyRemoved(id);
            if (count != 0) break block1;
            this.callOnRelease();
        }
    }

    private void callOnRelease() throws ClosedIllegalStateException {
        if (this.released && !Jvm.supportThread()) {
            throw new ClosedIllegalStateException(this.type.getName() + " already released", this.releasedHere);
        }
        this.releasedHere = Jvm.isResourceTracing() ? new StackTrace("Released here") : null;
        this.released = true;
        this.onRelease.run();
        this.referenceChangeListeners.clear();
    }

    @Override
    public void releaseLast(ReferenceOwner id) throws IllegalStateException {
        Exception thrownException = null;
        try {
            this.release(id);
        }
        catch (Exception e) {
            thrownException = e;
        }
        if (this.value > 0) {
            IllegalStateException ise = new IllegalStateException(this.type.getName() + " not the last released");
            if (thrownException != null) {
                ise.addSuppressed(thrownException);
            }
            throw ise;
        }
        if (thrownException != null) {
            Jvm.rethrow(thrownException);
        }
    }

    @Override
    public int refCount() {
        return this.value;
    }

    public String toString() {
        return Integer.toString(this.value);
    }

    @Override
    public void throwExceptionIfNotReleased() throws IllegalStateException {
        if (this.refCount() > 0) {
            throw new IllegalStateException(this.type.getName() + " still reserved, count=" + this.refCount());
        }
    }

    @Override
    public void warnAndReleaseIfNotReleased() throws IllegalStateException {
        if (this.valueGetAndSet(0) <= 0) {
            return;
        }
        if (!this.unmonitored && !AbstractCloseable.DISABLE_DISCARD_WARNING) {
            Jvm.warn().on(this.type, "Discarded without being released");
        }
        try {
            this.callOnRelease();
        }
        catch (ClosedIllegalStateException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public void unmonitored(boolean unmonitored) {
        this.unmonitored = unmonitored;
    }

    @Override
    public boolean unmonitored() {
        return this.unmonitored;
    }

    @Override
    public void addReferenceChangeListener(ReferenceChangeListener referenceChangeListener) {
        this.referenceChangeListeners.add(referenceChangeListener);
    }

    @Override
    public void removeReferenceChangeListener(ReferenceChangeListener referenceChangeListener) {
        this.referenceChangeListeners.remove(referenceChangeListener);
    }

    private ClosedIllegalStateException newReleasedClosedIllegalStateException() {
        return new ClosedIllegalStateException(this.type.getName() + " released");
    }
}

