/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.api.column;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.openhft.chronicle.core.util.ObjectUtils;
import net.openhft.chronicle.engine.api.column.ClosableIterator;
import net.openhft.chronicle.engine.api.column.Column;
import net.openhft.chronicle.engine.api.column.Row;
import net.openhft.chronicle.engine.api.tree.Asset;
import net.openhft.chronicle.engine.map.ObjectSubscription;
import net.openhft.chronicle.wire.AbstractMarshallable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ColumnViewInternal {
    public Asset asset();

    @Nullable
    public List<Column> columns();

    public int rowCount(@NotNull SortedFilter var1);

    public int changedRow(@NotNull Map<String, Object> var1, @NotNull Map<String, Object> var2);

    public void registerChangeListener(@NotNull Runnable var1);

    @NotNull
    public ClosableIterator<? extends Row> iterator(@NotNull SortedFilter var1);

    public boolean canDeleteRows();

    public boolean containsRowWithKey(List var1);

    @Nullable
    public ObjectSubscription objectSubscription();

    @Nullable
    default public Predicate<Number> toPredicate(@NotNull String value) {
        if (value.contains(",")) {
            String[] v = value.split("\\,");
            Predicate predicate = null;
            for (String x : v) {
                String xTrimed = x.trim();
                Boolean atStart = DOp.isAtStart(xTrimed = DOp.checkShouldPrependEQ(xTrimed));
                if (atStart == null) continue;
                predicate = predicate == null ? DOp.toPredicate(xTrimed, atStart) : predicate.and(DOp.toPredicate(xTrimed, atStart));
            }
            return predicate;
        }
        value = DOp.checkShouldPrependEQ(value);
        Boolean atStart = DOp.isAtStart(value);
        return DOp.toPredicate(value, atStart);
    }

    @Nullable
    default public Predicate<Number> predicate(@NotNull List<MarshableFilter> filters) {
        Predicate<Number> predicate = null;
        for (MarshableFilter f : filters) {
            predicate = predicate == null ? this.toPredicate(f.filter.trim()) : predicate.and(this.toPredicate(f.filter.trim()));
        }
        return predicate;
    }

    public static enum DOp {
        GE(true, new String[]{">=", "["}){

            @Override
            boolean compare(double a, double b) {
                return a >= b;
            }
        }
        ,
        LE(true, new String[]{"<="}){

            @Override
            boolean compare(double a, double b) {
                return a <= b;
            }
        }
        ,
        NE(true, new String[]{"<>", "!=", "!"}){

            @Override
            boolean compare(double a, double b) {
                return a != b;
            }
        }
        ,
        GT(true, new String[]{">", "("}){

            @Override
            boolean compare(double a, double b) {
                return a > b;
            }
        }
        ,
        LT(true, new String[]{"<"}){

            @Override
            boolean compare(double a, double b) {
                return a < b;
            }
        }
        ,
        EQ(true, new String[]{"==", "="}){

            @Override
            boolean compare(double a, double b) {
                return a == b;
            }
        }
        ,
        LT_INCLUSIVE(false, new String[]{"]"}){

            @Override
            boolean compare(double a, double b) {
                return a <= b;
            }
        }
        ,
        LT_EXCLUSIVE(false, new String[]{")"}){

            @Override
            boolean compare(double a, double b) {
                return a < b;
            }
        };

        static final DOp[] OPS;
        final String[] op;
        private final boolean operationAtStart;

        private DOp(boolean operationAtStart, String ... op) {
            this.op = op;
            this.operationAtStart = operationAtStart;
        }

        @Nullable
        private Number number(@NotNull String op, @NotNull String value, Class<? extends Number> clazz) throws Exception {
            String number;
            String string = number = this.operationAtStart ? value.substring(op.length()).trim() : value.substring(0, value.length() - op.length()).trim();
            if (!number.isEmpty()) {
                return (Number)ObjectUtils.convertTo(clazz, (Object)number);
            }
            throw new RuntimeException("can not parse number from '" + value + "'");
        }

        abstract boolean compare(double var1, double var3);

        private static Boolean isAtStart(@NotNull String value) {
            for (DOp dop : OPS) {
                for (String op : dop.op) {
                    if (dop.operationAtStart) {
                        if (!value.startsWith(op)) continue;
                        return true;
                    }
                    if (!value.endsWith(op)) continue;
                    return false;
                }
            }
            return null;
        }

        @NotNull
        private static String checkShouldPrependEQ(@NotNull String x) {
            return DOp.isAtStart(x) == null ? "=" + x : x;
        }

        private static Predicate<Number> toPredicate(@NotNull String value, boolean operationAtStart) {
            for (DOp dop : OPS) {
                if (dop.operationAtStart != operationAtStart) continue;
                for (String op : dop.op) {
                    Number number;
                    if (dop.operationAtStart ? !value.startsWith(op) : !value.endsWith(op)) continue;
                    try {
                        number = dop.number(op, value.trim(), Double.class);
                    }
                    catch (Exception e) {
                        return n -> false;
                    }
                    try {
                        return o -> dop.compare(o.doubleValue(), number.doubleValue());
                    }
                    catch (ClassCastException e) {
                        return n -> false;
                    }
                }
            }
            return n -> false;
        }

        static {
            OPS = DOp.values();
        }
    }

    public static class SortedFilter
    extends AbstractMarshallable {
        public long countFromEnd;
        public long fromIndex;
        @NotNull
        public List<MarshableOrderBy> marshableOrderBy = new ArrayList<MarshableOrderBy>();
        @NotNull
        public List<MarshableFilter> marshableFilters = new ArrayList<MarshableFilter>();
    }

    public static class MarshableOrderBy
    extends AbstractMarshallable {
        public final String column;
        public final boolean isAscending;

        public MarshableOrderBy(String column) {
            this.column = column;
            this.isAscending = false;
        }

        public MarshableOrderBy(String column, boolean isAscending) {
            this.column = column;
            this.isAscending = isAscending;
        }
    }

    public static class MarshableFilter
    extends AbstractMarshallable {
        public final String columnName;
        public final String filter;

        public MarshableFilter(String columnName, String filter) {
            this.columnName = columnName;
            this.filter = filter;
        }
    }
}

