/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.api.map;

import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import net.openhft.chronicle.engine.api.KeyedVisitable;
import net.openhft.chronicle.engine.api.Updatable;
import net.openhft.chronicle.engine.api.map.MapEvent;
import net.openhft.chronicle.engine.api.pubsub.Reference;
import net.openhft.chronicle.engine.api.pubsub.Subscriber;
import net.openhft.chronicle.engine.api.pubsub.TopicSubscriber;
import net.openhft.chronicle.engine.api.set.EntrySetView;
import net.openhft.chronicle.engine.api.set.KeySetView;
import net.openhft.chronicle.engine.api.tree.Assetted;
import net.openhft.chronicle.engine.api.tree.KeyedView;
import net.openhft.chronicle.engine.api.tree.RequestContext;
import net.openhft.chronicle.engine.query.Filter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface MapView<K, V>
extends ConcurrentMap<K, V>,
Assetted<Object>,
Updatable<MapView<K, V>>,
KeyedVisitable<K, V>,
Function<K, V>,
KeyedView {
    @Override
    @NotNull
    public KeySetView<K> keySet();

    @NotNull
    public EntrySetView<K, Object, V> entrySet();

    @Nullable
    public V getUsing(K var1, Object var2);

    public void registerTopicSubscriber(@NotNull TopicSubscriber<K, V> var1);

    public void registerKeySubscriber(@NotNull Subscriber<K> var1);

    public void registerKeySubscriber(@NotNull Subscriber<K> var1, @NotNull Filter var2, @NotNull Set<RequestContext.Operation> var3);

    public void registerSubscriber(@NotNull Subscriber<MapEvent<K, V>> var1);

    public void registerSubscriber(@NotNull Subscriber<MapEvent<K, V>> var1, @NotNull Filter<MapEvent<K, V>> var2, @NotNull Set<RequestContext.Operation> var3);

    public Reference<V> referenceFor(K var1);

    public Class<K> keyType();

    public Class<V> valueType();

    @Override
    @Nullable
    default public V apply(K k) {
        return this.get((Object)k);
    }

    @Override
    default public int size() {
        return (int)Math.min(Integer.MAX_VALUE, this.longSize());
    }

    public long longSize();

    @Nullable
    public V getAndPut(K var1, V var2);

    @Nullable
    public V getAndRemove(K var1);
}

