/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.api.tree;

import java.lang.reflect.Proxy;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.core.pool.ClassAliasPool;
import net.openhft.chronicle.core.pool.ClassLookup;
import net.openhft.chronicle.engine.HeartbeatHandler;
import net.openhft.chronicle.engine.api.collection.ValuesCollection;
import net.openhft.chronicle.engine.api.column.ColumnView;
import net.openhft.chronicle.engine.api.column.VaadinChart;
import net.openhft.chronicle.engine.api.map.MapEvent;
import net.openhft.chronicle.engine.api.map.MapView;
import net.openhft.chronicle.engine.api.pubsub.Publisher;
import net.openhft.chronicle.engine.api.pubsub.Reference;
import net.openhft.chronicle.engine.api.pubsub.Replication;
import net.openhft.chronicle.engine.api.pubsub.SubscriptionCollection;
import net.openhft.chronicle.engine.api.pubsub.TopicPublisher;
import net.openhft.chronicle.engine.api.session.Heartbeat;
import net.openhft.chronicle.engine.api.set.EntrySetView;
import net.openhft.chronicle.engine.api.set.KeySetView;
import net.openhft.chronicle.engine.cfg.ChronicleMapCfg;
import net.openhft.chronicle.engine.cfg.ClustersCfg;
import net.openhft.chronicle.engine.cfg.EngineCfg;
import net.openhft.chronicle.engine.cfg.EngineClusterContext;
import net.openhft.chronicle.engine.cfg.FilePerKeyMapCfg;
import net.openhft.chronicle.engine.cfg.InMemoryMapCfg;
import net.openhft.chronicle.engine.cfg.JmxCfg;
import net.openhft.chronicle.engine.cfg.MonitorCfg;
import net.openhft.chronicle.engine.cfg.QueueCfg;
import net.openhft.chronicle.engine.cfg.ServerCfg;
import net.openhft.chronicle.engine.cfg.VanillaWireOutPublisherFactory;
import net.openhft.chronicle.engine.fs.ChronicleMapGroupFS;
import net.openhft.chronicle.engine.fs.EngineConnectionManager;
import net.openhft.chronicle.engine.map.AuthenticatedKeyValueStore;
import net.openhft.chronicle.engine.map.ObjectKeyValueStore;
import net.openhft.chronicle.engine.map.ObjectSubscription;
import net.openhft.chronicle.engine.map.RawKVSSubscription;
import net.openhft.chronicle.engine.query.Filter;
import net.openhft.chronicle.engine.query.Operation;
import net.openhft.chronicle.engine.server.internal.EngineNetworkStatsListener;
import net.openhft.chronicle.engine.server.internal.EngineWireNetworkContext;
import net.openhft.chronicle.engine.server.internal.MapReplicationHandler;
import net.openhft.chronicle.engine.server.internal.UberHandler;
import net.openhft.chronicle.engine.tree.QueueView;
import net.openhft.chronicle.engine.tree.TopologicalEvent;
import net.openhft.chronicle.engine.tree.TopologySubscription;
import net.openhft.chronicle.network.TcpEventHandler;
import net.openhft.chronicle.network.cluster.ClusterContext;
import net.openhft.chronicle.network.cluster.HostIdConnectionStrategy;
import net.openhft.chronicle.network.cluster.TerminatorHandler;
import net.openhft.chronicle.wire.QueryWire;
import net.openhft.chronicle.wire.VanillaWireParser;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireParser;
import net.openhft.chronicle.wire.WireType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RequestContext
implements Cloneable {
    public static final ClassLookup CLASS_ALIASES = ClassLookup.create();
    private String pathName;
    private String name;
    private Class viewType;
    private Class type;
    private Class type2;
    private String basePath;
    private WireType wireType = WireType.TEXT;
    @Nullable
    private Boolean putReturnsNull = null;
    @Nullable
    private Boolean removeReturnsNull = null;
    @Nullable
    private Boolean nullOldValueOnUpdateEvent = null;
    @Nullable
    private Boolean endSubscriptionAfterBootstrap = null;
    @Nullable
    private Boolean bootstrap = null;
    private double averageValueSize;
    private long entries;
    private Boolean recurse;
    private boolean sealed = false;
    private String cluster = "cluster";
    private int throttlePeriodMs = 0;
    private boolean dontPersist;
    private long token;

    public static boolean loadDefaultAliases() {
        ClassAliasPool.CLASS_ALIASES.addAlias(new Class[]{ChronicleMapGroupFS.class, EngineCfg.class, JmxCfg.class, ServerCfg.class, ClustersCfg.class, InMemoryMapCfg.class, FilePerKeyMapCfg.class, ChronicleMapCfg.class, MonitorCfg.class});
        return true;
    }

    private RequestContext() {
    }

    public RequestContext(String pathName, String name) {
        this.pathName = pathName;
        this.name = name;
    }

    private static void addAlias(Class type, @NotNull String aliases) {
        ClassAliasPool.CLASS_ALIASES.addAlias(type, aliases);
    }

    private static void addAlias(Class ... type) {
        ClassAliasPool.CLASS_ALIASES.addAlias(type);
    }

    private static void addAliasLocal(Class type, @NotNull String aliases) {
        CLASS_ALIASES.addAlias(type, aliases);
    }

    private static void addAlias(String className) {
        Class<?> aClass;
        try {
            aClass = Class.forName(className);
        }
        catch (ClassNotFoundException ignore) {
            return;
        }
        CLASS_ALIASES.addAlias(aClass, aClass.getSimpleName());
    }

    @NotNull
    public static RequestContext requestContext() {
        return new RequestContext();
    }

    @NotNull
    public static RequestContext requestContext(@NotNull CharSequence uri) {
        return RequestContext.requestContext(uri.toString());
    }

    @NotNull
    public static RequestContext requestContext(@NotNull String uri) {
        int queryPos = uri.indexOf(63);
        String fullName = queryPos >= 0 ? uri.substring(0, queryPos) : uri;
        String query = queryPos >= 0 ? uri.substring(queryPos + 1) : "";
        int lastForwardSlash = fullName.lastIndexOf(47);
        if (lastForwardSlash > 0 && fullName.length() == lastForwardSlash + 1) {
            fullName = fullName.substring(0, fullName.length() - 1);
            lastForwardSlash = fullName.lastIndexOf(47);
        }
        String pathName = lastForwardSlash >= 0 ? fullName.substring(0, lastForwardSlash) : "";
        String name = lastForwardSlash >= 0 ? fullName.substring(lastForwardSlash + 1) : fullName;
        RequestContext requestContext = new RequestContext(pathName, name).queryString(query);
        return requestContext;
    }

    static Class lookupType(@NotNull CharSequence typeName) throws ClassNotFoundException {
        return CLASS_ALIASES.forName(typeName);
    }

    @NotNull
    public RequestContext cluster(String clusterTwo) {
        this.cluster = clusterTwo;
        return this;
    }

    @NotNull
    public String cluster() {
        return this.cluster;
    }

    @NotNull
    public RequestContext seal() {
        this.sealed = true;
        return this;
    }

    @NotNull
    public Class<SubscriptionCollection> getSubscriptionType() {
        Class elementType = this.elementType();
        return elementType == TopologicalEvent.class ? TopologySubscription.class : (elementType == BytesStore.class ? RawKVSSubscription.class : ObjectSubscription.class);
    }

    @NotNull
    public RequestContext queryString(@NotNull String queryString) {
        if (queryString.isEmpty()) {
            return this;
        }
        WireParser<Void> parser = this.getWireParser();
        Bytes bytes = Bytes.from((CharSequence)queryString);
        QueryWire wire = new QueryWire(bytes);
        while (bytes.readRemaining() > 0L) {
            parser.parseOne((WireIn)wire, null);
        }
        return this;
    }

    @NotNull
    public WireParser<Void> getWireParser() {
        VanillaWireParser parser = new VanillaWireParser((s, v, $) -> {});
        parser.register(() -> "cluster", (s, v, $) -> v.text((Object)this, (o, x) -> {
            o.cluster = x;
        }));
        parser.register(() -> "view", (s, v, $) -> v.text((Object)this, RequestContext::view));
        parser.register(() -> "bootstrap", (s, v, $) -> v.bool((Object)this, (o, x) -> {
            o.bootstrap = x;
        }));
        parser.register(() -> "putReturnsNull", (s, v, $) -> v.bool((Object)this, (o, x) -> {
            o.putReturnsNull = x;
        }));
        parser.register(() -> "removeReturnsNull", (s, v, $) -> v.bool((Object)this, (o, x) -> {
            o.removeReturnsNull = x;
        }));
        parser.register(() -> "nullOldValueOnUpdateEvent", (s, v, $) -> v.bool((Object)this, (o, x) -> {
            o.nullOldValueOnUpdateEvent = x;
        }));
        parser.register(() -> "viewType", (s, v, $) -> v.typeLiteral((Object)this, (o, x) -> {
            o.viewType = x;
        }));
        parser.register(() -> "topicType", (s, v, $) -> v.typeLiteral((Object)this, (o, x) -> {
            o.type = x;
        }));
        parser.register(() -> "keyType", (s, v, $) -> v.typeLiteral((Object)this, (o, x) -> {
            o.type = x;
        }));
        parser.register(() -> "valueType", (s, v, $) -> v.typeLiteral((Object)this, (o, x) -> {
            o.type2 = x;
        }));
        parser.register(() -> "messageType", (s, v, $) -> v.typeLiteral((Object)this, (o, x) -> {
            o.type = x;
        }));
        parser.register(() -> "elementType", (s, v, $) -> v.typeLiteral((Object)this, (o, x) -> {
            o.type2 = x;
        }));
        parser.register(() -> "endSubscriptionAfterBootstrap", (s, v, $) -> v.bool((Object)this, (o, x) -> {
            o.endSubscriptionAfterBootstrap = x;
        }));
        parser.register(() -> "throttlePeriodMs", (s, v, $) -> v.int32((Object)this, (o, x) -> {
            o.throttlePeriodMs = x;
        }));
        parser.register(() -> "entries", (s, v, $) -> v.int64((Object)this, (o, x) -> {
            o.entries = x;
        }));
        parser.register(() -> "averageValueSize", (s, v, $) -> v.int64((Object)this, (o, x) -> {
            o.averageValueSize = x;
        }));
        parser.register(() -> "dontPersist", (s, v, $) -> v.bool((Object)this, (o, x) -> {
            o.dontPersist = x;
        }));
        parser.register(() -> "token", (s, v, $) -> v.int64((Object)this, (o, x) -> {
            o.token = x;
        }));
        return parser;
    }

    @NotNull
    public RequestContext view(@NotNull String viewName) {
        try {
            Class clazz = RequestContext.lookupType(viewName);
            this.viewType(clazz);
        }
        catch (ClassNotFoundException iae) {
            throw new IllegalArgumentException("Unknown view name=" + viewName);
        }
        return this;
    }

    @NotNull
    public RequestContext type(Class type) {
        this.checkSealed();
        this.type = type;
        return this;
    }

    @NotNull
    public RequestContext keyType(Class type) {
        this.checkSealed();
        this.type = type;
        return this;
    }

    @NotNull
    public Class type() {
        if (this.type == null) {
            return String.class;
        }
        return this.type;
    }

    @NotNull
    public Class elementType() {
        if (this.type2 != null) {
            return this.type2;
        }
        return String.class;
    }

    public Class keyType() {
        if (this.type == null) {
            return String.class;
        }
        return this.type;
    }

    public Class valueType() {
        if (this.type2 == null) {
            return String.class;
        }
        return this.type2;
    }

    public Class topicType() {
        if (this.type == null) {
            return String.class;
        }
        return this.type;
    }

    public Class messageType() {
        if (this.type == null) {
            return String.class;
        }
        return this.type;
    }

    @NotNull
    public RequestContext messageType(Class clazz) {
        this.type = clazz;
        return this;
    }

    @NotNull
    public RequestContext valueType(Class type2) {
        this.checkSealed();
        this.type2 = type2;
        return this;
    }

    @NotNull
    public RequestContext type2(Class type2) {
        this.checkSealed();
        this.type2 = type2;
        return this;
    }

    public Class type2() {
        if (this.type == null) {
            return String.class;
        }
        return this.type2;
    }

    @NotNull
    public String fullName() {
        String s = this.pathName.isEmpty() ? this.name : this.pathName + "/" + this.name;
        return s.startsWith("/") ? s : "/" + s;
    }

    @NotNull
    public RequestContext basePath(String basePath) {
        this.checkSealed();
        this.basePath = basePath;
        return this;
    }

    public String basePath() {
        return this.basePath;
    }

    public String pathName() {
        return this.pathName;
    }

    @Deprecated
    @NotNull
    public RequestContext wireType(WireType writeType) {
        this.checkSealed();
        this.wireType = writeType;
        return this;
    }

    @Deprecated
    public WireType wireType() {
        return this.wireType;
    }

    public String name() {
        return this.name;
    }

    public double getAverageValueSize() {
        return this.averageValueSize;
    }

    @NotNull
    public RequestContext averageValueSize(double averageValueSize) {
        this.checkSealed();
        this.averageValueSize = averageValueSize;
        return this;
    }

    public long getEntries() {
        return this.entries;
    }

    @NotNull
    public RequestContext entries(long entries) {
        this.checkSealed();
        this.entries = entries;
        return this;
    }

    @NotNull
    public RequestContext name(String name) {
        this.name = name;
        return this;
    }

    @NotNull
    public RequestContext viewType(Class assetType) {
        this.checkSealed();
        this.viewType = assetType;
        return this;
    }

    @Nullable
    public Class viewType() {
        return this.viewType;
    }

    @NotNull
    public RequestContext fullName(@NotNull String fullName) {
        int dirPos = fullName.lastIndexOf(47);
        this.pathName = dirPos >= 0 ? fullName.substring(0, dirPos) : "";
        this.name = dirPos >= 0 ? fullName.substring(dirPos + 1) : fullName;
        return this;
    }

    @Nullable
    public Boolean putReturnsNull() {
        return this.putReturnsNull;
    }

    @Nullable
    public Boolean removeReturnsNull() {
        return this.removeReturnsNull;
    }

    @Nullable
    public RequestContext removeReturnsNull(Boolean removeReturnsNull) {
        this.removeReturnsNull = removeReturnsNull;
        return this;
    }

    @Nullable
    public Boolean nullOldValueOnUpdateEvent() {
        return this.nullOldValueOnUpdateEvent;
    }

    @Nullable
    public Boolean bootstrap() {
        return this.bootstrap;
    }

    @NotNull
    public RequestContext bootstrap(boolean bootstrap) {
        this.checkSealed();
        this.bootstrap = bootstrap;
        return this;
    }

    @NotNull
    public RequestContext endSubscriptionAfterBootstrap(boolean endSubscriptionAfterBootstrap) {
        this.checkSealed();
        this.endSubscriptionAfterBootstrap = endSubscriptionAfterBootstrap;
        return this;
    }

    @Nullable
    public Boolean endSubscriptionAfterBootstrap() {
        return this.endSubscriptionAfterBootstrap;
    }

    void checkSealed() {
        if (this.sealed) {
            throw new IllegalStateException();
        }
    }

    @NotNull
    public String toString() {
        return "RequestContext{pathName='" + this.pathName + '\'' + ", name='" + this.name + '\'' + ", viewType=" + this.viewType + ", type=" + this.type + ", type2=" + this.type2 + ", basePath='" + this.basePath + '\'' + ", wireType=" + this.wireType + ", putReturnsNull=" + this.putReturnsNull + ", removeReturnsNull=" + this.removeReturnsNull + ", bootstrap=" + this.bootstrap + ", averageValueSize=" + this.averageValueSize + ", entries=" + this.entries + ", recurse=" + this.recurse + ", endSubscriptionAfterBootstrap=" + this.endSubscriptionAfterBootstrap + ", throttlePeriodMs=" + this.throttlePeriodMs + ", dontPersist=" + this.dontPersist + '}';
    }

    public Boolean recurse() {
        return this.recurse;
    }

    @NotNull
    public RequestContext recurse(Boolean recurse) {
        this.recurse = recurse;
        return this;
    }

    @NotNull
    public RequestContext clone() {
        try {
            RequestContext clone = (RequestContext)super.clone();
            clone.sealed = false;
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    @NotNull
    public RequestContext putReturnsNull(Boolean putReturnsNull) {
        this.putReturnsNull = putReturnsNull;
        return this;
    }

    @NotNull
    public String toUri() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.fullName());
        String sep = "?";
        Class viewType = this.viewType;
        if (viewType != null) {
            String alias = CLASS_ALIASES.nameFor(viewType);
            sb.append(sep).append("view=").append(alias);
            sep = "&";
        }
        if (this.keyType() != null && this.keyType() != String.class) {
            sb.append(sep).append("keyType=").append(CLASS_ALIASES.nameFor(this.keyType()));
            sep = "&";
        }
        if (this.valueType() != null && this.valueType() != String.class) {
            sb.append(sep).append("valueType=").append(CLASS_ALIASES.nameFor(this.valueType()));
            sep = "&";
        }
        if (this.putReturnsNull() != null) {
            sb.append(sep).append("putReturnsNull=").append(this.putReturnsNull);
            sep = "&";
        }
        if (this.removeReturnsNull() != null) {
            sb.append(sep).append("removeReturnsNull=").append(this.putReturnsNull);
            sep = "&";
        }
        if (this.bootstrap() != null) {
            sb.append(sep).append("bootstrap=").append(this.bootstrap);
            sep = "&";
        }
        if (this.bootstrap() != null) {
            sb.append(sep).append("throttlePeriodMs=").append(this.throttlePeriodMs);
            sep = "&";
        }
        if (this.dontPersist()) {
            sb.append(sep).append("dontPersist").append(this.dontPersist);
            sep = "&";
        }
        return sb.toString();
    }

    public int throttlePeriodMs() {
        return this.throttlePeriodMs;
    }

    @NotNull
    public RequestContext throttlePeriodMs(int throttlePeriodMs) {
        this.throttlePeriodMs = throttlePeriodMs;
        return this;
    }

    @NotNull
    public <E> RequestContext elementType(Class<E> eClass) {
        this.type2 = eClass;
        return this;
    }

    @NotNull
    public RequestContext topicType(Class topicType) {
        this.type = topicType;
        return this;
    }

    public boolean dontPersist() {
        return this.dontPersist;
    }

    @NotNull
    public RequestContext dontPersist(boolean dontPersist) {
        this.dontPersist = dontPersist;
        return this;
    }

    public long token() {
        return this.token;
    }

    @NotNull
    public RequestContext token(long token) {
        this.token = token;
        return this;
    }

    static {
        RequestContext.loadDefaultAliases();
        RequestContext.addAliasLocal(VaadinChart.class, "Chart");
        RequestContext.addAliasLocal(ColumnView.class, "COLUMN");
        RequestContext.addAliasLocal(QueueView.class, "Queue");
        RequestContext.addAliasLocal(MapView.class, "Map");
        RequestContext.addAlias(MapEvent.class, "MapEvent");
        RequestContext.addAlias(TopologicalEvent.class, "TopologicalEvent");
        RequestContext.addAliasLocal(EntrySetView.class, "EntrySet");
        RequestContext.addAliasLocal(KeySetView.class, "KeySet");
        RequestContext.addAliasLocal(ValuesCollection.class, "Values");
        RequestContext.addAlias(Replication.class, "Replication");
        RequestContext.addAlias(Publisher.class, "Publisher, Pub");
        RequestContext.addAlias(TopicPublisher.class, "TopicPublisher, TopicPub");
        RequestContext.addAlias(ObjectSubscription.class, "Subscription");
        RequestContext.addAlias(TopologySubscription.class, "TopologySubscription");
        RequestContext.addAlias(Reference.class, "Reference, Ref");
        RequestContext.addAlias(net.openhft.chronicle.engine.query.Operation.class, "Operation");
        RequestContext.addAlias(Proxy.class, "set-proxy");
        RequestContext.addAlias(Operation.class, "QueryOperation");
        RequestContext.addAlias(Operation.OperationType.class, "QueryOperationType");
        RequestContext.addAlias(UberHandler.Factory.class, "UberHandlerFactory");
        RequestContext.addAlias(VanillaWireOutPublisherFactory.class, "VanillaWireOutPublisherFactory");
        RequestContext.addAlias(HostIdConnectionStrategy.class, "HostIdConnectionStrategy");
        RequestContext.addAlias(HeartbeatHandler.Factory.class, "HeartbeatHandlerFactory");
        RequestContext.addAlias(ClusterContext.class, "ClusterContext");
        RequestContext.addAlias(EngineWireNetworkContext.Factory.class, "EngineWireNetworkContextFactory");
        RequestContext.addAlias(EngineNetworkStatsListener.Factory.class, "EngineNetworkStatsListenerFactory");
        RequestContext.addAlias(EngineConnectionManager.Factory.class, "EngineConnectionManagerFactory");
        RequestContext.addAlias(TcpEventHandler.Factory.class, "TcpEventHandlerFactory");
        RequestContext.addAlias(EngineClusterContext.class, "EngineClusterContext");
        RequestContext.addAlias(UberHandler.class, "UberHandler");
        RequestContext.addAlias(MapReplicationHandler.class, "MapReplicationHandler");
        RequestContext.addAlias(HeartbeatHandler.class, "HeartbeatHandler");
        RequestContext.addAlias("software.chronicle.enterprise.queue.QueueSourceReplicationHandler");
        RequestContext.addAlias("software.chronicle.ente\u00a7rprise.queue.QueueSyncReplicationHandler");
        RequestContext.addAlias(QueueView.class, "QueueView");
        RequestContext.addAlias(Boolean.class, "boolean");
        RequestContext.addAlias(AuthenticatedKeyValueStore.class, "AuthenticatedKeyValueStore");
        RequestContext.addAlias(ObjectKeyValueStore.class, "ObjectKeyValueStore");
        RequestContext.addAlias(QueueCfg.class, WireType.class, Heartbeat.class, Filter.class, MapView.class, QueueView.class, TerminatorHandler.class);
    }

    public static enum Operation {
        END_SUBSCRIPTION_AFTER_BOOTSTRAP,
        BOOTSTRAP;


        public void apply(@NotNull RequestContext rc) {
            switch (this) {
                case END_SUBSCRIPTION_AFTER_BOOTSTRAP: {
                    rc.endSubscriptionAfterBootstrap(true);
                    break;
                }
                case BOOTSTRAP: {
                    rc.bootstrap(true);
                }
            }
        }
    }
}

